/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.model;

import com.sun.jersey.api.model.AbstractField;
import com.sun.jersey.api.model.AbstractModelComponent;
import com.sun.jersey.api.model.AbstractModelVisitor;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSetterMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.model.UriPathAnnotated;
import com.sun.jersey.api.model.UriPathValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResource
implements UriPathAnnotated,
AbstractModelComponent {
    private final Class<?> resourceClass;
    private final UriPathValue uriPath;
    private final List<AbstractResourceConstructor> constructors;
    private final List<AbstractField> fields;
    private final List<AbstractSetterMethod> setterMethods;
    private final List<AbstractResourceMethod> resourceMethods;
    private final List<AbstractSubResourceMethod> subResourceMethods;
    private final List<AbstractSubResourceLocator> subResourceLocators;

    public AbstractResource(Class<?> resourceClass) {
        this(resourceClass, null);
    }

    public AbstractResource(Class<?> resourceClass, UriPathValue uriPath) {
        this.resourceClass = resourceClass;
        this.uriPath = uriPath;
        this.constructors = new ArrayList<AbstractResourceConstructor>();
        this.fields = new ArrayList<AbstractField>();
        this.setterMethods = new ArrayList<AbstractSetterMethod>();
        this.resourceMethods = new ArrayList<AbstractResourceMethod>();
        this.subResourceLocators = new ArrayList<AbstractSubResourceLocator>();
        this.subResourceMethods = new ArrayList<AbstractSubResourceMethod>();
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public boolean isSubResource() {
        return this.uriPath == null;
    }

    public boolean isRootResource() {
        return this.uriPath != null;
    }

    @Override
    public UriPathValue getUriPath() {
        return this.uriPath;
    }

    public List<AbstractResourceConstructor> getConstructors() {
        return this.constructors;
    }

    public List<AbstractField> getFields() {
        return this.fields;
    }

    public List<AbstractSetterMethod> getSetterMethods() {
        return this.setterMethods;
    }

    public List<AbstractResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<AbstractSubResourceMethod> getSubResourceMethods() {
        return this.subResourceMethods;
    }

    public List<AbstractSubResourceLocator> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    @Override
    public void accept(AbstractModelVisitor visitor) {
        visitor.visitAbstractResource(this);
    }

    public String toString() {
        return "AbstractResource(" + (null == this.getUriPath() ? "" : "\"" + this.getUriPath().getValue() + "\", - ") + this.getResourceClass().getSimpleName() + ": " + this.getConstructors().size() + " constructors, " + this.getFields().size() + " fields, " + this.getSetterMethods().size() + " setter methods, " + this.getResourceMethods().size() + " res methods, " + this.getSubResourceMethods().size() + " subres methods, " + this.getSubResourceLocators().size() + " subres locators " + ")";
    }

    @Override
    public List<AbstractModelComponent> getComponents() {
        LinkedList<AbstractModelComponent> components = new LinkedList<AbstractModelComponent>();
        components.addAll(this.getConstructors());
        components.addAll(this.getSetterMethods());
        components.addAll(this.getResourceMethods());
        components.addAll(this.getSubResourceMethods());
        components.addAll(this.getSubResourceLocators());
        return components;
    }
}

