/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.server.linking.Binding;
import com.sun.jersey.server.linking.Ref;
import com.sun.jersey.server.linking.impl.FieldDescriptor;
import com.sun.jersey.server.linking.impl.RefDescriptor;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;

public class RefFieldDescriptor
extends FieldDescriptor
implements RefDescriptor {
    private Ref link;
    private Class<?> type;
    private Map<String, String> bindings;

    public RefFieldDescriptor(Field f, Ref l, Class<?> t) {
        super(f);
        this.link = l;
        this.type = t;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : l.bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    public void setPropertyValue(Object instance, URI value) {
        RefFieldDescriptor.setAccessibleField(this.field);
        try {
            this.field.set(instance, this.type.equals(URI.class) ? value : value.toString());
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(RefFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RefFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Ref.Style getLinkStyle() {
        return this.link.style();
    }

    @Override
    public String getLinkTemplate() {
        return RefFieldDescriptor.getLinkTemplate(this.link);
    }

    public static String getLinkTemplate(Ref link) {
        String template = null;
        if (!link.resource().equals(Class.class)) {
            Path path = link.resource().getAnnotation(Path.class);
            String string = template = path == null ? "" : path.value();
            if (link.method().length() > 0) {
                MethodList methods = new MethodList(link.resource());
                methods = methods.hasAnnotation(Path.class);
                for (AnnotatedMethod method : methods) {
                    if (!method.getMethod().getName().equals(link.method())) continue;
                    Path methodPath = (Path)method.getAnnotation(Path.class);
                    String methodTemplate = methodPath.value();
                    StringBuilder builder = new StringBuilder();
                    builder.append(template);
                    if (!template.endsWith("/") && !methodTemplate.startsWith("/")) {
                        builder.append("/");
                    }
                    builder.append(methodTemplate);
                    template = builder.toString();
                    break;
                }
            }
        } else {
            template = link.value();
        }
        return template;
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.link.condition();
    }
}

