/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.json.JSONMarshaller;
import com.sun.jersey.impl.json.JSONUnmarshaller;
import com.sun.jersey.impl.json.reader.JsonXmlStreamReader;
import com.sun.jersey.impl.json.writer.JsonXmlStreamWriter;
import com.sun.jersey.impl.provider.entity.AbstractRootElementProvider;
import com.sun.jersey.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class JSONRootElementProvider
extends AbstractRootElementProvider {
    public JSONRootElementProvider(@Context Providers ps) {
        super(ps, MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller(type, mediaType);
            if (unmarshaller instanceof JSONUnmarshaller) {
                unmarshaller.setProperty("com.sun.ws.rest.impl.json.enabled", (Object)Boolean.TRUE);
                JAXBElement jaxbElem = (JAXBElement)((JSONUnmarshaller)unmarshaller).unmarshal(new InputStreamReader(entityStream, JSONRootElementProvider.getCharset((MediaType)mediaType)), type);
                return jaxbElem.getValue();
            }
            return unmarshaller.unmarshal((XMLStreamReader)new JsonXmlStreamReader(new InputStreamReader(entityStream, JSONRootElementProvider.getCharset((MediaType)mediaType))));
        }
        catch (JAXBException cause) {
            throw (IOException)ThrowHelper.withInitCause((Exception)((Object)cause), (Exception)new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller marshaller = this.getMarshaller(t.getClass(), mediaType);
            if (marshaller instanceof JSONMarshaller) {
                marshaller.setProperty("com.sun.ws.rest.impl.json.enabled", (Object)Boolean.TRUE);
                marshaller.marshal(t, (Writer)new OutputStreamWriter(entityStream, JSONRootElementProvider.getCharset((MediaType)mediaType, (Charset)UTF8)));
            } else {
                marshaller.marshal(t, (XMLStreamWriter)new JsonXmlStreamWriter(new OutputStreamWriter(entityStream, JSONRootElementProvider.getCharset((MediaType)mediaType, (Charset)UTF8))));
            }
        }
        catch (JAXBException cause) {
            throw (IOException)ThrowHelper.withInitCause((Exception)((Object)cause), (Exception)new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }
}

