/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.provider.entity.AbstractRootElementProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRootElementProvider
extends AbstractRootElementProvider {
    XMLRootElementProvider(Providers ps) {
        super(ps);
    }

    XMLRootElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    protected final Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException, IOException {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return u.unmarshal(entityStream);
        }
        return u.unmarshal((Source)new StreamSource(entityStream), type).getValue();
    }

    @Override
    protected void writeTo(Object t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        m.marshal(t, entityStream);
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends XMLRootElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }
    }

    @Produces(value={"text/xml"})
    @Consumes(value={"text/xml"})
    public static final class Text
    extends XMLRootElementProvider {
        public Text(@Context Providers ps) {
            super(ps, MediaType.TEXT_XML_TYPE);
        }
    }

    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public static final class App
    extends XMLRootElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_XML_TYPE);
        }
    }
}

