/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriTemplate;

public final class PathTemplate
extends UriTemplate {
    public PathTemplate(String template) {
        this(template, false, true);
    }

    public PathTemplate(String template, boolean encode) {
        this(template, encode, true);
    }

    public PathTemplate(String template, boolean encode, boolean limited) {
        super(PathTemplate.encodeOrValidate(PathTemplate.prefixWithSlash(template), encode), limited);
    }

    private static String encodeOrValidate(String path, boolean encode) {
        if (encode) {
            return UriComponent.encode(path, UriComponent.Type.PATH, true);
        }
        UriComponent.validate(path, UriComponent.Type.PATH, true);
        return path;
    }

    private static String prefixWithSlash(String regex) {
        return !regex.startsWith("/") ? "/" + regex : regex;
    }
}

