/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.provider.entity.AbstractJAXBElementProvider;
import com.sun.jersey.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLJAXBElementProvider
extends AbstractJAXBElementProvider {
    public XMLJAXBElementProvider(Providers ps) {
        super(ps);
    }

    public XMLJAXBElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ParameterizedType pt = (ParameterizedType)genericType;
        Class ta = (Class)pt.getActualTypeArguments()[0];
        try {
            StreamSource source = new StreamSource(entityStream);
            return this.getUnmarshaller(ta, mediaType).unmarshal((Source)source, ta);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
    }

    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller marshaller = this.getMarshaller(t.getDeclaredType(), mediaType);
            String name = XMLJAXBElementProvider.getCharsetAsString(mediaType);
            if (name != null) {
                marshaller.setProperty("jaxb.encoding", (Object)name);
            }
            marshaller.marshal(t, entityStream);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends XMLJAXBElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }
    }

    @Produces(value={"text/xml"})
    @Consumes(value={"text/xml"})
    public static final class Text
    extends XMLJAXBElementProvider {
        public Text(@Context Providers ps) {
            super(ps, MediaType.TEXT_XML_TYPE);
        }
    }

    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public static final class App
    extends XMLJAXBElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_XML_TYPE);
        }
    }
}

