/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.http.header;

import com.sun.jersey.impl.http.header.reader.HttpHeaderReader;
import com.sun.jersey.impl.http.header.reader.HttpHeaderReaderImpl;
import java.text.ParseException;
import java.util.Locale;

public class LanguageTag {
    protected String tag;
    protected String primaryTag;
    protected String subTags;

    protected LanguageTag() {
    }

    public LanguageTag(String primaryTag, String subTags) {
        this.tag = subTags != null && subTags.length() > 0 ? primaryTag + "-" + subTags : primaryTag;
        this.primaryTag = primaryTag;
        this.subTags = subTags;
    }

    public LanguageTag(String header) throws ParseException {
        this(new HttpHeaderReaderImpl(header));
    }

    public LanguageTag(HttpHeaderReader reader) throws ParseException {
        reader.hasNext();
        this.tag = reader.nextToken();
        if (reader.hasNext()) {
            throw new ParseException("Invalid Language tag", reader.getIndex());
        }
        this.parse(this.tag);
    }

    public final boolean isCompatible(Locale tag) {
        if (this.tag.equals("*")) {
            return true;
        }
        return this.tag.equalsIgnoreCase(tag.toString());
    }

    protected final void parse(String languageTag) throws ParseException {
        if (!this.isValid(languageTag)) {
            throw new ParseException("String, " + languageTag + ", is not a valid language tag", 0);
        }
        int index = languageTag.indexOf(45);
        if (index == -1) {
            this.primaryTag = languageTag;
            this.subTags = null;
        } else {
            this.primaryTag = languageTag.substring(0, index);
            this.subTags = languageTag.substring(index + 1, languageTag.length());
        }
    }

    private boolean isValid(String tag) {
        int alphaCount = 0;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '-') {
                if (alphaCount == 0) {
                    return false;
                }
                alphaCount = 0;
                continue;
            }
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                if (++alphaCount <= 8) continue;
                return false;
            }
            return false;
        }
        return alphaCount != 0;
    }

    public final String getTag() {
        return this.tag;
    }

    public final String getPrimaryTag() {
        return this.primaryTag;
    }

    public final String getSubTags() {
        return this.subTags;
    }
}

