/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.impl.application.ComponentProviderCache;
import com.sun.jersey.impl.application.ContextResolverFactory;
import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.impl.application.MessageBodyFactory;
import com.sun.jersey.impl.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Client
extends Filterable
implements ClientHandler {
    private InjectableProviderFactory injectableFactory = new InjectableProviderFactory();
    private final ClientConfig config;
    private final ComponentProvider provider;
    private final MessageBodyFactory bodyContext;
    private Map<String, Object> properties;

    public Client(ClientHandler root) {
        this(root, new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public Client(ClientHandler root, ClientConfig config, ComponentProvider provider) {
        super(root);
        this.config = config;
        this.getProperties().putAll(config.getProperties());
        this.injectableFactory.add(new ContextInjectableProvider<ClientConfig>((Type)((Object)ClientConfig.class), config));
        this.provider = provider == null ? new DefaultComponentProvider() : new AdaptingComponentProvider(provider);
        ComponentProviderCache cpc = new ComponentProviderCache(this.injectableFactory, this.provider, config.getClasses(), config.getSingletons());
        final ContextResolverFactory crf = new ContextResolverFactory(cpc, this.injectableFactory);
        this.bodyContext = new MessageBodyFactory(cpc);
        this.injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), this.bodyContext));
        Providers p = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return Client.this.bodyContext.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return Client.this.bodyContext.getMessageBodyWriter(c, t, as, m);
            }

            public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                throw new IllegalArgumentException("This method is not supported on the client side");
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        this.injectableFactory.add(new ContextInjectableProvider<1>((Type)((Object)Providers.class), p));
        this.bodyContext.init();
        this.injectResources(root);
    }

    public WebResource resource(String u) {
        return this.resource(URI.create(u));
    }

    public WebResource resource(URI u) {
        return new WebResource(this, u);
    }

    public AsyncWebResource asyncResource(String u) {
        return this.asyncResource(URI.create(u));
    }

    public AsyncWebResource asyncResource(URI u) {
        return new AsyncWebResource(this, u);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setFollowRedirects(Boolean redirect) {
        this.getProperties().put("com.sun.jersey.client.property.followRedirects", redirect);
    }

    public void setReadTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.readTimeout", interval);
    }

    public void setConnectTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.connectTimeout", interval);
    }

    public void setChunkedEncodingSize(Integer chunkSize) {
        this.getProperties().put("com.sun.jersey.client.property.chunkedEncodingSize", chunkSize);
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        cr.getProperties().putAll(this.properties);
        return this.getHeadHandler().handle(cr);
    }

    private void injectResources(Object o) {
        this.injectableFactory.injectResources(o);
    }

    public static Client create() {
        return new Client(new URLConnectionClientHandler());
    }

    public static Client create(ClientConfig cc) {
        return new Client(new URLConnectionClientHandler(), cc);
    }

    public static Client create(ClientConfig cc, ComponentProvider cp) {
        return new Client(new URLConnectionClientHandler(), cc, cp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultComponentProvider
    implements ComponentProvider {
        private DefaultComponentProvider() {
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            T o = c.newInstance();
            Client.this.injectResources(o);
            return o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            T o = contructor.newInstance(parameters);
            Client.this.injectResources(o);
            return o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            return this.getInstance(scope, c);
        }

        public <T> T getInjectableInstance(T instance) {
            return instance;
        }

        public void inject(Object instance) {
            Client.this.injectResources(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AdaptingComponentProvider
    implements ComponentProvider {
        private final ComponentProvider cp;

        AdaptingComponentProvider(ComponentProvider cp) {
            this.cp = cp;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(scope, c);
            if (o == null) {
                o = c.newInstance();
                Client.this.injectResources(o);
            } else {
                Client.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object o = this.cp.getInstance(scope, contructor, parameters);
            if (o == null) {
                o = contructor.newInstance(parameters);
                Client.this.injectResources(o);
            } else {
                Client.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(cc, scope, c);
            if (o == null) {
                o = c.newInstance();
                Client.this.injectResources(o);
            } else {
                Client.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInjectableInstance(T instance) {
            return (T)this.cp.getInjectableInstance(instance);
        }

        public void inject(Object instance) {
            this.cp.inject(instance);
            Client.this.injectResources(this.cp.getInjectableInstance(instance));
        }
    }
}

