/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.osgi;

import com.sun.jersey.core.osgi.OsgiLocator;
import com.sun.jersey.impl.SpiMessages;
import com.sun.jersey.spi.service.ServiceConfigurationError;
import com.sun.jersey.spi.service.ServiceFinder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static boolean debug = false;
    private ConcurrentMap<Long, Map<String, Callable<List<Class>>>> factories = new ConcurrentHashMap<Long, Map<String, Callable<List<Class>>>>();
    private BundleContext bundleContext;

    protected void debugPrintln(String msg) {
        if (debug) {
            System.err.println("Spec(" + this.bundleContext.getBundle().getBundleId() + "): " + msg);
        }
    }

    public synchronized void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.debugPrintln("activating");
        this.debugPrintln("changing the default ServiceFinder lookup mechanism");
        ServiceFinder.setIteratorProvider(new OsgiServiceFinder());
        this.debugPrintln("adding bundle listener");
        bundleContext.addBundleListener((BundleListener)this);
        this.debugPrintln("checking existing bundles");
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
        this.debugPrintln("activated");
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        this.debugPrintln("deactivating");
        bundleContext.removeBundleListener((BundleListener)this);
        while (!this.factories.isEmpty()) {
            this.unregister((Long)this.factories.keySet().iterator().next());
        }
        this.debugPrintln("deactivated");
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        this.debugPrintln("checking bundle " + bundle.getBundleId());
        HashMap<String, BundleFactoryLoader> map = (HashMap<String, BundleFactoryLoader>)this.factories.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                if (map == null) {
                    map = new HashMap<String, BundleFactoryLoader>();
                    this.factories.put(bundle.getBundleId(), map);
                }
                map.put(factoryId, new BundleFactoryLoader(factoryId, u, bundle));
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.debugPrintln("registering service for key " + (String)entry.getKey() + "with value " + entry.getValue());
                OsgiLocator.register((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }

    protected void unregister(long bundleId) {
        Map map = (Map)this.factories.remove(bundleId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.debugPrintln("unregistering service for key " + (String)entry.getKey() + "with value " + entry.getValue());
                OsgiLocator.unregister((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }

    static {
        try {
            String prop = System.getProperty("org.apache.servicemix.specs.debug");
            debug = prop != null && !"false".equals(prop);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleFactoryLoader
    implements Callable<List<Class>> {
        private final String factoryId;
        private final URL u;
        private final Bundle bundle;

        public BundleFactoryLoader(String factoryId, URL u, Bundle bundle) {
            this.factoryId = factoryId;
            this.u = u;
            this.bundle = bundle;
        }

        @Override
        public List<Class> call() throws Exception {
            try {
                String factoryClassName;
                Activator.this.debugPrintln("creating factories for key: " + this.factoryId);
                BufferedReader br = new BufferedReader(new InputStreamReader(this.u.openStream(), "UTF-8"));
                ArrayList<Class> factoryClasses = new ArrayList<Class>();
                while ((factoryClassName = br.readLine()) != null) {
                    if (factoryClassName.trim().length() == 0) continue;
                    Activator.this.debugPrintln("factory implementation: " + factoryClassName);
                    factoryClasses.add(this.bundle.loadClass(factoryClassName));
                }
                br.close();
                return factoryClasses;
            }
            catch (Exception e) {
                Activator.this.debugPrintln("exception caught while creating factories: " + e);
                throw e;
            }
            catch (Error e) {
                Activator.this.debugPrintln("error caught while creating factories: " + e);
                throw e;
            }
        }

        public String toString() {
            return this.u.toString();
        }

        public int hashCode() {
            return this.u.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleFactoryLoader) {
                return this.u.equals(((BundleFactoryLoader)obj).u);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OsgiServiceFinder<T>
    extends ServiceFinder.ServiceIteratorProvider<T> {
        static final ServiceFinder.ServiceIteratorProvider defaultIterator = new ServiceFinder.DefaultServiceIteratorProvider();

        private OsgiServiceFinder() {
        }

        @Override
        public Iterator<T> createIterator(final Class<T> serviceClass, final String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List<Class> providerClasses = OsgiLocator.locateAll(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<T>(){
                    Iterator<Class> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Class nextClass = this.it.next();
                        try {
                            return serviceClass.cast(nextClass.newInstance());
                        }
                        catch (Exception ex) {
                            ServiceConfigurationError sce = new ServiceConfigurationError(serviceName + ": " + SpiMessages.PROVIDER_COULD_NOT_BE_CREATED(nextClass.getName(), serviceClass, ex.getLocalizedMessage()));
                            sce.initCause(ex);
                            throw sce;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return defaultIterator.createIterator(serviceClass, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public Iterator<Class<T>> createClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List<Class> providerClasses = OsgiLocator.locateAll(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<Class<T>>(){
                    Iterator<Class> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Class<T> next() {
                        return this.it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return defaultIterator.createClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
    }
}

