/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.json;

import com.sun.jersey.json.impl.ImplMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONConfiguration {
    private final Notation notation;
    private final Collection<String> arrays;
    private final Collection<String> attrsAsElems;
    private final Collection<String> nonStrings;
    private final boolean rootUnwrapping;
    private final Map<String, String> jsonXml2JsonNs;
    public static JSONConfiguration DEFAULT = JSONConfiguration.mapped().rootUnwrapping(true).build();

    private JSONConfiguration(Builder b) {
        this.notation = b.notation;
        this.arrays = b.arrays;
        this.attrsAsElems = b.attrsAsElems;
        this.nonStrings = b.nonStrings;
        this.rootUnwrapping = b.rootUnwrapping;
        this.jsonXml2JsonNs = b.jsonXml2JsonNs;
    }

    public static NaturalBuilder natural() {
        try {
            Class.forName("com.sun.xml.bind.annotation.OverrideAnnotationOf");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JSONConfiguration.class.getName()).log(Level.SEVERE, ImplMessages.ERROR_JAXB_RI_2_1_10_MISSING());
            throw new RuntimeException(ImplMessages.ERROR_JAXB_RI_2_1_10_MISSING());
        }
        return new NaturalBuilder(Notation.NATURAL);
    }

    public static MappedBuilder mapped() {
        return new MappedBuilder(Notation.MAPPED);
    }

    public static MappedJettisonBuilder mappedJettison() {
        return new MappedJettisonBuilder(Notation.MAPPED_JETTISON);
    }

    public static Builder badgerFish() {
        Builder badgerFishBuilder = new Builder(Notation.BADGERFISH);
        badgerFishBuilder.rootUnwrapping = false;
        return badgerFishBuilder;
    }

    public Notation getNotation() {
        return this.notation;
    }

    public Collection<String> getArrays() {
        return this.arrays != null ? Collections.unmodifiableCollection(this.arrays) : null;
    }

    public Collection<String> getAttributeAsElements() {
        return this.attrsAsElems != null ? Collections.unmodifiableCollection(this.attrsAsElems) : null;
    }

    public Map<String, String> getXml2JsonNs() {
        return this.jsonXml2JsonNs != null ? Collections.unmodifiableMap(this.jsonXml2JsonNs) : null;
    }

    public Collection<String> getNonStrings() {
        return this.nonStrings != null ? Collections.unmodifiableCollection(this.nonStrings) : null;
    }

    public boolean isRootUnwrapping() {
        return this.rootUnwrapping;
    }

    public String toString() {
        return String.format("{notation:%s,rootStripping:%b}", new Object[]{this.notation, this.rootUnwrapping});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappedBuilder
    extends Builder {
        private MappedBuilder(Notation notation) {
            super(notation);
        }

        public MappedBuilder arrays(String ... arrays) {
            this.arrays.addAll(Arrays.asList(arrays));
            return this;
        }

        public MappedBuilder attributeAsElement(String ... attributeAsElements) {
            this.attrsAsElems.addAll(Arrays.asList(attributeAsElements));
            return this;
        }

        public MappedBuilder nonStrings(String ... nonStrings) {
            this.nonStrings.addAll(Arrays.asList(nonStrings));
            return this;
        }

        public MappedBuilder xml2JsonNs(Map<String, String> jsonXml2JsonNs) {
            this.jsonXml2JsonNs = jsonXml2JsonNs;
            return this;
        }

        public MappedBuilder rootUnwrapping(boolean rootUnwrapping) {
            this.rootUnwrapping = rootUnwrapping;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappedJettisonBuilder
    extends Builder {
        private MappedJettisonBuilder(Notation notation) {
            super(notation);
            this.rootUnwrapping = false;
        }

        public MappedJettisonBuilder xml2JsonNs(Map<String, String> jsonXml2JsonNs) {
            this.jsonXml2JsonNs = jsonXml2JsonNs;
            return this;
        }
    }

    public static class NaturalBuilder
    extends Builder {
        private NaturalBuilder(Notation notation) {
            super(notation);
        }

        public NaturalBuilder rootUnwrapping(boolean rootUnwrapping) {
            this.rootUnwrapping = rootUnwrapping;
            return this;
        }
    }

    public static class Builder {
        private final Notation notation;
        protected Collection<String> arrays = new HashSet<String>(0);
        protected Collection<String> attrsAsElems = new HashSet<String>(0);
        protected Collection<String> nonStrings = new HashSet<String>(0);
        protected boolean rootUnwrapping = true;
        protected Map<String, String> jsonXml2JsonNs = new HashMap<String, String>(0);

        private Builder(Notation notation) {
            this.notation = notation;
        }

        public JSONConfiguration build() {
            return new JSONConfiguration(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Notation {
        MAPPED,
        MAPPED_JETTISON,
        BADGERFISH,
        NATURAL;

    }
}

