/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.container.filter;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.server.impl.container.filter.AnnotationResourceFilterFactory;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterFactory {
    private static final Logger LOGGER = Logger.getLogger(FilterFactory.class.getName());
    private final ProviderServices providerServices;
    private final List<ContainerRequestFilter> requestFilters = new LinkedList<ContainerRequestFilter>();
    private final List<ContainerResponseFilter> responseFilters = new LinkedList<ContainerResponseFilter>();
    private final List<ResourceFilterFactory> resourceFilterFactories = new LinkedList<ResourceFilterFactory>();

    public FilterFactory(ProviderServices providerServices, ResourceConfig resourceConfig) {
        this.providerServices = providerServices;
        this.requestFilters.addAll(this.getRequestFilters(resourceConfig.getProperty("com.sun.jersey.spi.container.ContainerRequestFilters")));
        this.requestFilters.addAll(providerServices.getServices(ContainerRequestFilter.class));
        this.responseFilters.addAll(this.getResponseFilters(resourceConfig.getProperty("com.sun.jersey.spi.container.ContainerResponseFilters")));
        this.responseFilters.addAll(providerServices.getServices(ContainerResponseFilter.class));
        this.resourceFilterFactories.addAll(this.getResourceFilterFactories(resourceConfig.getProperty("com.sun.jersey.spi.container.ResourceFilters")));
        this.resourceFilterFactories.addAll(providerServices.getServices(ResourceFilterFactory.class));
        this.resourceFilterFactories.add(new AnnotationResourceFilterFactory(this));
    }

    public List<ContainerRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public List<ContainerResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    public List<ResourceFilter> getResourceFilters(AbstractMethod am) {
        LinkedList<ResourceFilter> resourceFilters = new LinkedList<ResourceFilter>();
        for (ResourceFilterFactory rff : this.resourceFilterFactories) {
            List<ResourceFilter> rfs = rff.create(am);
            if (rfs == null) continue;
            resourceFilters.addAll(rfs);
        }
        return resourceFilters;
    }

    public List<ResourceFilter> getResourceFilters(Class<? extends ResourceFilter>[] classes) {
        if (classes == null || classes.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.providerServices.getInstances(ResourceFilter.class, classes);
    }

    public List<ContainerRequestFilter> getRequestFilters(List<ResourceFilter> resourceFilters) {
        LinkedList<ContainerRequestFilter> filters = new LinkedList<ContainerRequestFilter>();
        for (ResourceFilter rf : resourceFilters) {
            ContainerRequestFilter crf = rf.getRequestFilter();
            if (crf == null) continue;
            filters.add(crf);
        }
        return filters;
    }

    public List<ContainerResponseFilter> getResponseFilters(List<ResourceFilter> resourceFilters) {
        LinkedList<ContainerResponseFilter> filters = new LinkedList<ContainerResponseFilter>();
        for (ResourceFilter rf : resourceFilters) {
            ContainerResponseFilter crf = rf.getResponseFilter();
            if (crf == null) continue;
            filters.add(crf);
        }
        return filters;
    }

    private List<ContainerRequestFilter> getRequestFilters(Object o) {
        return this.getFilters(ContainerRequestFilter.class, o);
    }

    private List<ContainerResponseFilter> getResponseFilters(Object o) {
        return this.getFilters(ContainerResponseFilter.class, o);
    }

    private List<ResourceFilterFactory> getResourceFilterFactories(Object o) {
        return this.getFilters(ResourceFilterFactory.class, o);
    }

    private <T> List<T> getFilters(Class<T> c, Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof String) {
            return this.getFilters(c, DefaultResourceConfig.getElements(new String[]{(String)o}));
        }
        if (o instanceof String[]) {
            return this.getFilters(c, DefaultResourceConfig.getElements((String[])o));
        }
        if (o instanceof List) {
            return this.getFilters(c, (List)o);
        }
        LOGGER.severe("The filters, " + o.getClass().getName() + " declared for " + c.getName() + "MUST be of the type String[], String or List");
        return Collections.emptyList();
    }

    private <T> List<T> getFilters(Class<T> c, String[] classNames) {
        LinkedList<T> f = new LinkedList<T>();
        f.addAll(this.providerServices.getInstances(c, classNames));
        return f;
    }

    private <T> List<T> getFilters(Class<T> c, List<?> l) {
        LinkedList<T> f = new LinkedList<T>();
        for (Object o : l) {
            if (!c.isInstance(o)) {
                LOGGER.severe("The filter, " + o.getClass().getName() + " MUST be an instance of " + c.getName() + ". The filter is ignored.");
                continue;
            }
            f.add(c.cast(o));
        }
        this.providerServices.getComponentProviderFactory().injectOnProviderInstances(f);
        return f;
    }
}

