/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.reflection;

import com.sun.jersey.impl.ImplMessages;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    public static Class classForName(String name) {
        return ReflectionHelper.classForName(name, ReflectionHelper.getContextClassLoader());
    }

    public static Class classForName(String name, ClassLoader cl) {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class classForNameWithException(String name) throws ClassNotFoundException {
        return ReflectionHelper.classForNameWithException(name, ReflectionHelper.getContextClassLoader());
    }

    public static Class classForNameWithException(String name, ClassLoader cl) throws ClassNotFoundException {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public static Class getGenericClass(Type parameterizedType) throws IllegalArgumentException {
        if (!(parameterizedType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)parameterizedType;
        Type[] genericTypes = type.getActualTypeArguments();
        if (genericTypes.length != 1) {
            return null;
        }
        Type genericType = genericTypes[0];
        if (genericType instanceof Class) {
            return (Class)genericTypes[0];
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Type t = arrayType.getGenericComponentType();
            if (t instanceof Class) {
                Class c = (Class)t;
                try {
                    Object o = Array.newInstance(c, 0);
                    return o.getClass();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(genericType, parameterizedType));
        }
        throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(genericType, parameterizedType));
    }

    public static Method getValueOfStringMethod(Class c) {
        try {
            Method m = c.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getFromStringStringMethod(Class c) {
        try {
            Method m = c.getDeclaredMethod("fromString", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getStringConstructor(Class c) {
        try {
            return c.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class[] getParameterizedClassArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Class[] cas = new Class[as.length];
            for (int i = 0; i < as.length; ++i) {
                Type a = as[i];
                if (a instanceof Class) {
                    cas[i] = (Class)a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    cas[i] = (Class)pt.getRawType();
                    continue;
                }
                if (!(a instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a);
                cas[i] = ctp.c;
            }
            return cas;
        }
        return null;
    }

    public static DeclaringClassInterfacePair getClass(Class concrete, Class iface) {
        return ReflectionHelper.getClass(concrete, iface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class iface, Class c) {
        Type[] gis = c.getGenericInterfaces();
        DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c, gis);
        if (p != null) {
            return p;
        }
        if ((c = c.getSuperclass()) == null || c == Object.class) {
            return null;
        }
        return ReflectionHelper.getClass(concrete, iface, c);
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c, Type[] ts) {
        for (Type t : ts) {
            DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c, t);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c, Type t) {
        if (t instanceof Class) {
            if (t == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)pt.getRawType());
        }
        return null;
    }

    public static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv) {
        return ReflectionHelper.resolveTypeVariable(c, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        for (Type gi : gis = c.getGenericInterfaces()) {
            ParameterizedType pt;
            ClassTypePair ctp;
            if (!(gi instanceof ParameterizedType) || (ctp = ReflectionHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map)) == null) continue;
            return ctp;
        }
        Type gsc = c.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return ReflectionHelper.resolveTypeVariable(pt, c.getSuperclass(), dc, tv, map);
        }
        if (gsc instanceof Class) {
            return ReflectionHelper.resolveTypeVariable(c.getSuperclass(), dc, tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = c.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t = map.get(typeArguments[i]);
                submap.put(typeParameters[i], t);
                continue;
            }
            submap.put(typeParameters[i], typeArguments[i]);
        }
        if (c == dc) {
            Type t = (Type)submap.get(tv);
            if (t instanceof Class) {
                return new ClassTypePair((Class)t);
            }
            if (t instanceof GenericArrayType) {
                if ((t = ((GenericArrayType)t).getGenericComponentType()) instanceof Class) {
                    c = (Class)t;
                    try {
                        Object o = Array.newInstance(c, 0);
                        return new ClassTypePair((Class)o.getClass());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t instanceof ParameterizedType) {
                pt = (ParameterizedType)t;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return ReflectionHelper.resolveTypeVariable(c, dc, tv, submap);
    }

    public static class ClassTypePair {
        public final Class c;
        public final Type t;

        private ClassTypePair(Class c) {
            this(c, c);
        }

        private ClassTypePair(Class c, Type t) {
            this.c = c;
            this.t = t;
        }
    }

    public static class DeclaringClassInterfacePair {
        public final Class concreteClass;
        public final Class declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class concreteClass, Class declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }
}

