/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.model.method.dispatch;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.impl.http.header.reader.HttpHeaderReader;
import com.sun.jersey.impl.http.header.reader.HttpHeaderReaderImpl;
import com.sun.jersey.impl.model.method.dispatch.FormDispatchProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.service.ComponentProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartFormDispatchProvider
extends FormDispatchProvider {
    private static MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    @Context
    MessageBodyWorkers mbws;

    @Override
    protected void processForm(HttpContext context) {
        MediaType m = context.getRequest().getMediaType();
        if (m != null && m.isCompatible(MULTIPART_FORM_DATA)) {
            MimeMultipart form = context.getRequest().getEntity(MimeMultipart.class);
            try {
                Map<String, BodyPart> formMap = MultipartFormDispatchProvider.getFormData(form);
                context.getProperties().put("com.sun.jersey.api.representation.form", formMap);
                context.getProperties().put("com.sun.jersey.api.representation.form.multipart", form);
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        } else {
            Form form = context.getRequest().getEntity(Form.class);
            context.getProperties().put("com.sun.jersey.api.representation.form", form);
        }
    }

    @Override
    public RequestDispatcher create(AbstractResourceMethod method) {
        MediaType m;
        boolean found = false;
        Iterator<MediaType> i$ = method.getSupportedInputTypes().iterator();
        while (i$.hasNext() && !(found = !(m = i$.next()).isWildcardSubtype() && m.isCompatible(MULTIPART_FORM_DATA))) {
        }
        if (!found) {
            return null;
        }
        return super.create(method);
    }

    @Override
    protected List<Injectable> getInjectables(AbstractResourceMethod method) {
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter p = method.getParameters().get(i);
            if (Parameter.Source.ENTITY == p.getSource()) {
                if (MimeMultipart.class.isAssignableFrom(p.getParameterClass()) || MultivaluedMap.class.isAssignableFrom(p.getParameterClass())) {
                    is.add(new MultipartFormInjectable(p.getParameterClass(), p.getParameterType(), p.getAnnotations()));
                    continue;
                }
                is.add(null);
                continue;
            }
            if (p.getAnnotation().annotationType() == FormParam.class) {
                is.add(new MultipartFormParamInjectable(this.mbws, p));
                continue;
            }
            Injectable injectable = this.ipc.getInjectable(p, ComponentProvider.Scope.PerRequest);
            is.add(injectable);
        }
        return is;
    }

    private static Map<String, BodyPart> getFormData(MimeMultipart mm) throws Exception {
        HashMap<String, BodyPart> m = new HashMap<String, BodyPart>();
        for (int i = 0; i < mm.getCount(); ++i) {
            String name;
            BodyPart b = mm.getBodyPart(i);
            if (b.getDisposition() == null || !b.getDisposition().equalsIgnoreCase("form-data") || (name = MultipartFormDispatchProvider.getName(b.getHeader("content-disposition")[0])) == null) continue;
            m.put(name, b);
        }
        return m;
    }

    private static String getName(String disposition) throws ParseException {
        HttpHeaderReaderImpl reader = new HttpHeaderReaderImpl(disposition);
        ((HttpHeaderReader)reader).hasNext();
        reader.nextToken();
        while (((HttpHeaderReader)reader).hasNext()) {
            reader.nextSeparator(';');
            if (!((HttpHeaderReader)reader).hasNext()) break;
            String name = reader.nextToken();
            reader.nextSeparator('=');
            String value = reader.nextTokenOrQuotedString();
            if (!name.equalsIgnoreCase("name")) continue;
            return value;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultipartFormParamInjectable
    implements Injectable<Object> {
        private final MessageBodyWorkers mbws;
        private final Parameter p;

        MultipartFormParamInjectable(MessageBodyWorkers mbws, Parameter p) {
            this.mbws = mbws;
            this.p = p;
        }

        @Override
        public Object getValue(HttpContext context) {
            try {
                Object o = context.getProperties().get("com.sun.jersey.api.representation.form");
                if (o instanceof Form) {
                    return this.getAsForm((Form)o, context);
                }
                return this.getAsMultipartFormData((Map)o, context);
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }

        private Object getAsForm(Form form, HttpContext context) throws Exception {
            String c = form.getFirst(this.p.getSourceName());
            ByteArrayInputStream is = new ByteArrayInputStream(c.getBytes("UTF-8"));
            MessageBodyReader<?> r = this.mbws.getMessageBodyReader(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), MediaType.TEXT_PLAIN_TYPE);
            return r.readFrom(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), MediaType.TEXT_PLAIN_TYPE, context.getRequest().getRequestHeaders(), (InputStream)is);
        }

        private Object getAsMultipartFormData(Map<String, BodyPart> formMap, HttpContext context) throws Exception {
            BodyPart bp = formMap.get(this.p.getSourceName());
            if (bp == null) {
                return null;
            }
            MediaType m = bp.getContentType() == null ? MediaType.TEXT_PLAIN_TYPE : MediaType.valueOf((String)bp.getContentType());
            MessageBodyReader<?> r = this.mbws.getMessageBodyReader(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), m);
            return r.readFrom(this.p.getParameterClass(), this.p.getParameterType(), this.p.getAnnotations(), m, context.getRequest().getRequestHeaders(), bp.getInputStream());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultipartFormInjectable
    implements Injectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        MultipartFormInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            Object o = context.getProperties().get("com.sun.jersey.api.representation.form.multipart");
            if (o != null) {
                return o;
            }
            return context.getProperties().get("com.sun.jersey.api.representation.form");
        }
    }
}

