/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.application.ComponentProviderCache;
import com.sun.jersey.impl.model.ReflectionHelper;
import com.sun.jersey.impl.modelapi.annotation.AnnotatedMethod;
import com.sun.jersey.impl.modelapi.annotation.MethodList;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectableProviderFactory
implements InjectableProviderContext {
    private static final Logger LOGGER = Logger.getLogger(InjectableProviderFactory.class.getName());
    private Map<Class<? extends Annotation>, LinkedList<MetaInjectableProvider>> ipm = new HashMap<Class<? extends Annotation>, LinkedList<MetaInjectableProvider>>();

    public void add(InjectableProvider ip) {
        Type[] args = this.getMetaArguments(ip.getClass());
        if (args != null) {
            MetaInjectableProvider mip = new MetaInjectableProvider(ip, (Class)args[0], (Class)args[1]);
            this.getList(mip.ac).add(mip);
        }
    }

    public void configure(ComponentProviderCache componentProviderCache) {
        for (InjectableProvider ip : componentProviderCache.getProvidersAndServices(InjectableProvider.class)) {
            this.add(ip);
        }
    }

    private LinkedList<MetaInjectableProvider> getList(Class<? extends Annotation> c) {
        LinkedList<MetaInjectableProvider> l = this.ipm.get(c);
        if (l == null) {
            l = new LinkedList();
            this.ipm.put(c, l);
        }
        return l;
    }

    private Type[] getMetaArguments(Class<? extends InjectableProvider> c) {
        for (Class<? extends InjectableProvider> _c = c; _c != Object.class; _c = _c.getSuperclass()) {
            Type[] ts;
            for (Type t : ts = _c.getGenericInterfaces()) {
                ParameterizedType pt;
                if (!(t instanceof ParameterizedType) || (pt = (ParameterizedType)t).getRawType() != InjectableProvider.class) continue;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.getResolvedType(args[i], c, _c);
                }
                if (!(args[0] instanceof Class) || !(args[1] instanceof Class) || args[1] != Type.class && args[1] != Parameter.class) continue;
                return args;
            }
        }
        return null;
    }

    private Type getResolvedType(Type t, Class c, Class dc) {
        if (t instanceof Class) {
            return t;
        }
        if (t instanceof TypeVariable) {
            ReflectionHelper.ClassTypePair ct = ReflectionHelper.resolveTypeVariable(c, dc, (TypeVariable)t);
            if (ct != null) {
                return ct.c;
            }
            return t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return pt.getRawType();
        }
        return t;
    }

    private List<MetaInjectableProvider> findInjectableProviders(Class<? extends Annotation> ac, Class<?> cc, ComponentProvider.Scope s) {
        ArrayList<MetaInjectableProvider> subips = new ArrayList<MetaInjectableProvider>();
        for (MetaInjectableProvider i : this.getList(ac)) {
            if (s != i.ip.getScope() || !i.cc.isAssignableFrom(cc)) continue;
            subips.add(i);
        }
        return subips;
    }

    @Override
    public <A extends Annotation, C> Injectable getInjectable(Class<? extends Annotation> ac, ComponentContext ic, A a, C c, ComponentProvider.Scope s) {
        return this.getInjectable(ac, ic, a, c, Collections.singletonList(s));
    }

    @Override
    public <A extends Annotation, C> Injectable getInjectable(Class<? extends Annotation> ac, ComponentContext ic, A a, C c, List<ComponentProvider.Scope> ls) {
        for (ComponentProvider.Scope s : ls) {
            Injectable i = this._getInjectable(ac, ic, a, c, s);
            if (i == null) continue;
            return i;
        }
        return null;
    }

    private <A extends Annotation, C> Injectable _getInjectable(Class<? extends Annotation> ac, ComponentContext ic, A a, C c, ComponentProvider.Scope s) {
        for (MetaInjectableProvider mip : this.findInjectableProviders(ac, c.getClass(), s)) {
            Injectable i = mip.ip.getInjectable(ic, a, c);
            if (i == null) continue;
            return i;
        }
        return null;
    }

    @Override
    public Injectable getInjectable(Parameter p, ComponentProvider.Scope s) {
        if (p.getAnnotation() == null) {
            return null;
        }
        AnnotationObjectContext ic = new AnnotationObjectContext(p.getAnnotations());
        if (s == ComponentProvider.Scope.PerRequest) {
            Injectable i = this.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)ic, p.getAnnotation(), p, ComponentProvider.Scope.PerRequest);
            if (i != null) {
                return i;
            }
            return this.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)ic, p.getAnnotation(), p.getParameterType(), ComponentProvider.Scope.PERREQUEST_UNDEFINED_SINGLETON);
        }
        return this.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)ic, p.getAnnotation(), p.getParameterType(), ComponentProvider.Scope.UNDEFINED_SINGLETON);
    }

    @Override
    public List<Injectable> getInjectable(List<Parameter> ps, ComponentProvider.Scope s) {
        ArrayList<Injectable> is = new ArrayList<Injectable>();
        for (Parameter p : ps) {
            is.add(this.getInjectable(p, s));
        }
        return is;
    }

    public void injectResources(Object o) {
        Injectable i;
        AccessibleObjectContext aoc = new AccessibleObjectContext();
        for (Class<?> oClass = o.getClass(); oClass != Object.class; oClass = oClass.getSuperclass()) {
            for (Field f : oClass.getDeclaredFields()) {
                Annotation[] as;
                if (this.getFieldValue(o, f) != null) continue;
                aoc.setAccesibleObject(f);
                for (Annotation a : as = f.getAnnotations()) {
                    i = this.getInjectable(a.annotationType(), (ComponentContext)aoc, a, f.getGenericType(), ComponentProvider.Scope.UNDEFINED_SINGLETON);
                    if (i == null) continue;
                    this.setFieldValue(o, f, i.getValue(null));
                }
            }
        }
        MethodList ml = new MethodList(o.getClass().getMethods());
        for (AnnotatedMethod m : ml.hasNotMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).hasNumParams(1).hasReturnType(Void.TYPE).nameStartsWith("set")) {
            Annotation[] as = m.getAnnotations();
            aoc.setAccesibleObject(m.getMethod(), as);
            Type t = m.getGenericParameterTypes()[0];
            for (Annotation a : as) {
                i = this.getInjectable(a.annotationType(), (ComponentContext)aoc, a, t, ComponentProvider.Scope.UNDEFINED_SINGLETON);
                if (i == null) continue;
                this.setMethodValue(o, m, i.getValue(null));
            }
        }
    }

    private void setFieldValue(final Object resource, final Field f, final Object value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    f.set(resource, value);
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new ContainerException(e);
                }
            }
        });
    }

    private Object getFieldValue(final Object resource, final Field f) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    return f.get(resource);
                }
                catch (IllegalAccessException e) {
                    throw new ContainerException(e);
                }
            }
        });
    }

    private void setMethodValue(Object o, AnnotatedMethod m, Object value) {
        try {
            m.getMethod().invoke(o, value);
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
    }

    public static final class AnnotationObjectContext
    implements ComponentContext {
        private Annotation[] annotations;

        public AnnotationObjectContext() {
        }

        public AnnotationObjectContext(Annotation[] annotations) {
            this.annotations = annotations;
        }

        public void setAnnotations(Annotation[] annotations) {
            this.annotations = annotations;
        }

        public AccessibleObject getAccesibleObject() {
            return null;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }
    }

    public static final class AccessibleObjectContext
    implements ComponentContext {
        private AccessibleObject accesibleObject;
        private Annotation[] annotations;

        public AccessibleObjectContext() {
        }

        public AccessibleObjectContext(AccessibleObject ao) {
            this.accesibleObject = ao;
        }

        public AccessibleObjectContext(AccessibleObject ao, Annotation[] annotations) {
            this.accesibleObject = ao;
            this.annotations = annotations;
        }

        public void setAccesibleObject(AccessibleObject ao) {
            this.accesibleObject = ao;
        }

        public void setAccesibleObject(AccessibleObject ao, Annotation[] annotations) {
            this.accesibleObject = ao;
            this.annotations = annotations;
        }

        public AccessibleObject getAccesibleObject() {
            return this.accesibleObject;
        }

        public Annotation[] getAnnotations() {
            if (this.annotations != null) {
                return this.annotations;
            }
            return this.accesibleObject.getAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaInjectableProvider {
        final InjectableProvider ip;
        final Class<? extends Annotation> ac;
        final Class<?> cc;

        MetaInjectableProvider(InjectableProvider ip, Class<? extends Annotation> ac, Class<?> cc) {
            this.ip = ip;
            this.ac = ac;
            this.cc = cc;
        }
    }
}

