/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl;

import com.sun.jersey.impl.ResponseImpl;
import com.sun.jersey.impl.util.KeyComparatorHashMap;
import com.sun.jersey.impl.util.StringIgnoreCaseKeyComparator;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseBuilderImpl
extends Response.ResponseBuilder {
    static final int CACHE_CONTROL = 0;
    static final int CONTENT_LANGUAGE = 1;
    static final int CONTENT_LOCATION = 2;
    static final int CONTENT_TYPE = 3;
    static final int ETAG = 4;
    static final int LAST_MODIFIED = 5;
    static final int LOCATION = 6;
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final Map<String, Integer> HEADER_MAP = ResponseBuilderImpl.createHeaderMap();
    private static final String[] HEADER_ARRAY = ResponseBuilderImpl.createHeaderArray();
    private int status = 204;
    private Object entity;
    private Type entityType;
    private Object[] values;
    private List<Object> nameValuePairs;

    private static Map<String, Integer> createHeaderMap() {
        KeyComparatorHashMap<String, Integer> m = new KeyComparatorHashMap<String, Integer>(StringIgnoreCaseKeyComparator.SINGLETON);
        m.put("Cache-Control", 0);
        m.put("Content-Language", 1);
        m.put("Content-Location", 2);
        m.put("Content-Type", 3);
        m.put("ETag", 4);
        m.put("Last-Modified", 5);
        m.put("Location", 6);
        return Collections.unmodifiableMap(m);
    }

    private static String[] createHeaderArray() {
        Map<String, Integer> m = ResponseBuilderImpl.createHeaderMap();
        String[] a = new String[m.size()];
        for (Map.Entry<String, Integer> e : m.entrySet()) {
            a[e.getValue().intValue()] = e.getKey();
        }
        return a;
    }

    static String getHeader(int id) {
        return HEADER_ARRAY[id];
    }

    public ResponseBuilderImpl() {
    }

    private ResponseBuilderImpl(ResponseBuilderImpl that) {
        this.status = that.status;
        this.entity = that.entity;
        this.entityType = that.entityType;
        if (that.values != null) {
            this.values = (Object[])that.values.clone();
        }
        if (that.nameValuePairs != null) {
            this.nameValuePairs = new ArrayList<Object>(that.nameValuePairs);
        }
    }

    public Response.ResponseBuilder entityWithType(Object entity, Type entityType) {
        this.entity = entity;
        this.entityType = entityType;
        return this;
    }

    public Response build() {
        ResponseImpl r = new ResponseImpl(this.status, this.entity, this.entityType, this.values != null ? this.values : EMPTY_VALUES, this.nameValuePairs != null ? this.nameValuePairs : Collections.emptyList());
        this.reset();
        return r;
    }

    private void reset() {
        this.status = 204;
        this.entity = null;
        this.values = null;
        this.nameValuePairs = null;
    }

    public Response.ResponseBuilder clone() {
        return new ResponseBuilderImpl(this);
    }

    public Response.ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        this.entityType = entity != null ? entity.getClass() : null;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        this.set(3, type);
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type != null) {
            this.set(3, MediaType.valueOf((String)type));
        } else {
            this.set(3, null);
        }
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.type((MediaType)null);
            this.language((String)null);
            this.header("Content-Encoding", null);
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        if (variant.getEncoding() != null) {
            this.header("Content-Encoding", variant.getEncoding());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        if (variants == null) {
            this.header("Vary", null);
            return this;
        }
        if (variants.isEmpty()) {
            return this;
        }
        MediaType accept = variants.get(0).getMediaType();
        boolean vAccept = false;
        Locale acceptLanguage = variants.get(0).getLanguage();
        boolean vAcceptLanguage = false;
        String acceptEncoding = variants.get(0).getEncoding();
        boolean vAcceptEncoding = false;
        for (Variant v : variants) {
            vAccept |= !vAccept && this.vary(v.getMediaType(), accept);
            vAcceptLanguage |= !vAcceptLanguage && this.vary(v.getLanguage(), acceptLanguage);
            vAcceptEncoding |= !vAcceptEncoding && this.vary(v.getEncoding(), acceptEncoding);
        }
        StringBuilder vary = new StringBuilder();
        this.append(vary, vAccept, "Accept");
        this.append(vary, vAcceptLanguage, "Accept-Language");
        this.append(vary, vAcceptEncoding, "Accept-Encoding");
        if (vary.length() > 0) {
            this.header("Vary", vary.toString());
        }
        return this;
    }

    private boolean vary(MediaType v, MediaType vary) {
        return v != null && !v.equals((Object)vary);
    }

    private boolean vary(Locale v, Locale vary) {
        return v != null && !v.equals(vary);
    }

    private boolean vary(String v, String vary) {
        return v != null && !v.equalsIgnoreCase(vary);
    }

    private void append(StringBuilder sb, boolean v, String s) {
        if (v) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(s);
        }
    }

    public Response.ResponseBuilder language(String language) {
        this.set(1, language);
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        if (language != null) {
            this.set(1, language);
        } else {
            this.set(1, null);
        }
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        this.set(6, location);
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        this.set(2, location);
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        this.set(4, tag);
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag != null) {
            this.set(4, new EntityTag(tag));
        } else {
            this.set(4, null);
        }
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        this.set(5, lastModified);
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        this.set(0, cacheControl);
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        this.add("Expires", expires);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies != null) {
            for (NewCookie cookie : cookies) {
                this.add("Set-Cookie", cookie);
            }
        } else {
            this.remove("Set-Cookie");
        }
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        Integer id = HEADER_MAP.get(name);
        if (id != null) {
            this.set(id, value);
        } else {
            this.add(name, value);
        }
        return this;
    }

    private void add(String name, Object value) {
        if (value != null) {
            if (this.nameValuePairs == null) {
                this.nameValuePairs = new LinkedList<Object>();
            }
            this.nameValuePairs.add(name);
            this.nameValuePairs.add(value);
        } else {
            this.remove(name);
        }
    }

    private void remove(String name) {
        if (this.nameValuePairs == null) {
            return;
        }
        Iterator<Object> i = this.nameValuePairs.iterator();
        while (i.hasNext()) {
            if (i.next().toString().equalsIgnoreCase(name)) {
                i.remove();
                i.next();
                i.remove();
                continue;
            }
            i.next();
        }
    }

    private void set(int id, Object value) {
        if (this.values == null) {
            this.values = new Object[HEADER_MAP.size()];
        }
        this.values[id] = value;
    }
}

