/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.spi.StringReader;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringReaderExtractor
implements MultivaluedParameterExtractor {
    private final StringReader sr;
    private final String parameter;
    private final String defaultValueString;

    public StringReaderExtractor(StringReader sr, String parameter, String defaultValueString) {
        this.sr = sr;
        this.parameter = parameter;
        this.defaultValueString = defaultValueString;
        Object defaultValue = defaultValueString != null ? sr.fromString(defaultValueString) : null;
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        String v = (String)parameters.getFirst((Object)this.parameter);
        if (v != null) {
            return this.sr.fromString(v);
        }
        if (this.defaultValueString != null) {
            return this.sr.fromString(this.defaultValueString);
        }
        return null;
    }
}

