/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.component.ioc;

import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentProvider;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCProxiedComponentProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;

public class IoCProviderFactory
extends ProviderFactory {
    private final IoCComponentProviderFactory icpf;

    public IoCProviderFactory(InjectableProviderContext ipc, IoCComponentProviderFactory icpf) {
        super(ipc);
        this.icpf = icpf;
    }

    public ComponentProvider _getComponentProvider(Class c) {
        IoCComponentProvider icp = this.icpf.getComponentProvider(c);
        return icp == null ? super._getComponentProvider(c) : this.wrap(c, icp);
    }

    private ComponentProvider wrap(Class c, IoCComponentProvider icp) {
        if (icp instanceof IoCManagedComponentProvider) {
            IoCManagedComponentProvider imcp = (IoCManagedComponentProvider)icp;
            if (imcp.getScope() == ComponentScope.Singleton) {
                return new SingletonWrapper(this.getInjectableProviderContext(), imcp, c);
            }
            throw new RuntimeException("The scope of the component " + c + " must be a singleton");
        }
        if (icp instanceof IoCInstantiatedComponentProvider) {
            IoCInstantiatedComponentProvider iicp = (IoCInstantiatedComponentProvider)icp;
            return new SingletonWrapper(this.getInjectableProviderContext(), iicp, c);
        }
        if (icp instanceof IoCProxiedComponentProvider) {
            IoCProxiedComponentProvider ipcp = (IoCProxiedComponentProvider)icp;
            ComponentProvider cp = super._getComponentProvider(c);
            return new ProxiedSingletonWrapper(ipcp, cp, c);
        }
        throw new UnsupportedOperationException();
    }

    private static class ProxiedSingletonWrapper
    implements ComponentProvider {
        private final Object o;

        ProxiedSingletonWrapper(IoCProxiedComponentProvider ipcp, ComponentProvider cp, Class c) {
            Object _o = cp.getInstance();
            this.o = ipcp.proxy(_o);
            if (!this.o.getClass().isAssignableFrom(_o.getClass())) {
                throw new IllegalStateException("Proxied object class " + this.o.getClass() + " is not assignable from object class " + _o.getClass());
            }
        }

        public Object getInstance() {
            return this.o;
        }
    }

    private static class SingletonWrapper
    implements ComponentProvider {
        private final Object o;

        SingletonWrapper(InjectableProviderContext ipc, IoCInstantiatedComponentProvider iicp, Class c) {
            ComponentInjector<Object> rci = new ComponentInjector<Object>(ipc, c);
            this.o = iicp.getInstance();
            rci.inject(iicp.getInjectableInstance(this.o));
        }

        public Object getInstance() {
            return this.o;
        }
    }
}

