/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.container.grizzly;

import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public final class GrizzlyContainer
extends GrizzlyAdapter
implements ContainerListener {
    private WebApplication application;

    public GrizzlyContainer(WebApplication app) throws ContainerException {
        this.application = app;
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        WebApplication _application = this.application;
        URI baseUri = this.getBaseUri(request);
        URI requestUri = baseUri.resolve(request.getRequest().unparsedURI().toString());
        try {
            ContainerRequest cRequest = new ContainerRequest(_application, request.getMethod(), baseUri, requestUri, this.getHeaders(request), (InputStream)request.getInputStream());
            _application.handleRequest(cRequest, new Writer(response));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
    }

    private URI getBaseUri(GrizzlyRequest request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private InBoundHeaders getHeaders(GrizzlyRequest request) {
        InBoundHeaders rh = new InBoundHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            rh.add(name, value);
        }
        return rh;
    }

    public void onReload() {
        this.application = this.application.clone();
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final GrizzlyResponse response;

        Writer(GrizzlyResponse response) {
            this.response = response;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            this.response.setStatus(cResponse.getStatus());
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : cResponse.getHttpHeaders().entrySet()) {
                for (Object value : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), ContainerResponse.getHeaderValue(value));
                }
            }
            String contentType = this.response.getHeader("Content-Type");
            if (contentType != null) {
                this.response.setContentType(contentType);
            }
            return this.response.getOutputStream();
        }

        public void finish() throws IOException {
        }
    }
}

