/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.component;

import com.sun.jersey.core.spi.component.ComponentConstructor;
import com.sun.jersey.core.spi.component.ComponentDestructor;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentProvider;
import com.sun.jersey.core.spi.component.ComponentProviderFactory;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderFactory
implements ComponentProviderFactory<ComponentProvider> {
    private static final Logger LOGGER = Logger.getLogger(ProviderFactory.class.getName());
    private final Map<Class, ComponentProvider> cache = new HashMap<Class, ComponentProvider>();
    private final InjectableProviderContext ipc;

    public ProviderFactory(InjectableProviderContext ipc) {
        this.ipc = ipc;
    }

    public InjectableProviderContext getInjectableProviderContext() {
        return this.ipc;
    }

    @Override
    public final ComponentProvider getComponentProvider(Class c) {
        ComponentProvider cp = this.cache.get(c);
        if (cp != null) {
            return cp;
        }
        cp = this._getComponentProvider(c);
        if (cp != null) {
            this.cache.put(c, cp);
        }
        return cp;
    }

    protected ComponentProvider _getComponentProvider(Class c) {
        try {
            Object o = this.getInstance(c);
            ComponentInjector<Object> ci = new ComponentInjector<Object>(this.ipc, c);
            ci.inject(o);
            return new SingletonComponentProvider(ci, o);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.log(Level.CONFIG, "A dependent class, " + ex.getLocalizedMessage() + ", of the component " + c + " is not found." + " The component is ignored.");
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "The provider class, " + c + ", could not be instantiated", ex);
            return null;
        }
    }

    public void injectOnAllComponents() {
        for (ComponentProvider cp : this.cache.values()) {
            if (!(cp instanceof SingletonComponentProvider)) continue;
            SingletonComponentProvider scp = (SingletonComponentProvider)cp;
            scp.inject();
        }
    }

    public void destroy() {
        for (ComponentProvider cp : this.cache.values()) {
            if (!(cp instanceof SingletonComponentProvider)) continue;
            SingletonComponentProvider scp = (SingletonComponentProvider)cp;
            scp.destroy();
        }
    }

    public void injectOnProviderInstances(Collection<?> providers) {
        for (Object o : providers) {
            this.injectOnProviderInstance(o);
        }
    }

    public void injectOnProviderInstance(Object provider) {
        Class<?> c = provider.getClass();
        ComponentInjector ci = new ComponentInjector(this.ipc, c);
        ci.inject(provider);
    }

    private Object getInstance(Class c) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ComponentConstructor cc = new ComponentConstructor(this.ipc, c);
        return cc.getInstance();
    }

    private static final class SingletonComponentProvider
    implements ComponentProvider {
        private final Object o;
        private final ComponentDestructor cd;
        private final ComponentInjector ci;

        SingletonComponentProvider(ComponentInjector ci, Object o) {
            this.cd = new ComponentDestructor(o.getClass());
            this.ci = ci;
            this.o = o;
        }

        public Object getInstance() {
            return this.o;
        }

        public void inject() {
            this.ci.inject(this.o);
        }

        public void destroy() {
            try {
                this.cd.destroy(this.o);
            }
            catch (IllegalAccessException ex) {
                LOGGER.log(Level.SEVERE, "Unable to destroy resource", ex);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.SEVERE, "Unable to destroy resource", ex);
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unable to destroy resource", ex);
            }
        }
    }
}

