/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider.jaxb;

import com.sun.jersey.core.provider.jaxb.AbstractJAXBProvider;
import com.sun.jersey.core.util.ThrowHelper;
import com.sun.jersey.impl.ImplMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRootElementProvider
extends AbstractJAXBProvider<Object> {
    public AbstractRootElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractRootElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (type.getAnnotation(XmlRootElement.class) != null || type.getAnnotation(XmlType.class) != null) && this.isSupported(mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null && this.isSupported(mediaType);
    }

    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return this.readFrom(type, mediaType, this.getUnmarshaller(type, mediaType), entityStream);
        }
        catch (UnmarshalException ex) {
            throw new WebApplicationException((Throwable)ex, 400);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
    }

    protected abstract Object readFrom(Class<Object> var1, MediaType var2, Unmarshaller var3, InputStream var4) throws JAXBException, IOException;

    public final void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller m = this.getMarshaller(type, mediaType);
            Charset c = AbstractRootElementProvider.getCharset(mediaType);
            if (c != UTF8) {
                m.setProperty("jaxb.encoding", (Object)c.name());
            }
            this.writeTo(t, mediaType, c, m, entityStream);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }

    protected abstract void writeTo(Object var1, MediaType var2, Charset var3, Marshaller var4, OutputStream var5) throws JAXBException, IOException;
}

