/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.GenericType;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientResponse {
    protected static final RuntimeDelegate.HeaderDelegate<EntityTag> entityTagDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class);
    protected static final RuntimeDelegate.HeaderDelegate<Date> dateDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(Date.class);

    public abstract Map<String, Object> getProperties();

    public abstract int getStatus();

    public abstract void setStatus(int var1);

    public abstract Response.Status getResponseStatus();

    public abstract void setResponseStatus(Response.Status var1);

    public abstract MultivaluedMap<String, String> getMetadata();

    public abstract boolean hasEntity();

    public abstract InputStream getEntityInputStream();

    public abstract void setEntityInputStream(InputStream var1);

    public abstract <T> T getEntity(Class<T> var1) throws IllegalArgumentException;

    public abstract <T> T getEntity(GenericType<T> var1) throws IllegalArgumentException;

    public MediaType getType() {
        String ct = (String)this.getMetadata().getFirst((Object)"Content-Type");
        return ct != null ? MediaType.valueOf((String)ct) : null;
    }

    public URI getLocation() {
        String l = (String)this.getMetadata().getFirst((Object)"Location");
        return l != null ? URI.create(l) : null;
    }

    public EntityTag getEntityTag() {
        String t = (String)this.getMetadata().getFirst((Object)"ETag");
        return t != null ? (EntityTag)entityTagDelegate.fromString(t) : null;
    }

    public Date getLastModified() {
        String d = (String)this.getMetadata().getFirst((Object)"Last-Modified");
        return d != null ? (Date)dateDelegate.fromString(d) : null;
    }

    public String getLanguage() {
        return (String)this.getMetadata().getFirst((Object)"Content-Language");
    }

    public List<NewCookie> getCookies() {
        List hs = (List)this.getMetadata().get((Object)"Set-Cookie");
        if (hs == null) {
            return Collections.emptyList();
        }
        ArrayList<NewCookie> cs = new ArrayList<NewCookie>();
        for (String h : hs) {
            cs.add(NewCookie.valueOf((String)h));
        }
        return cs;
    }
}

