/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.impl.ResponseImpl;
import com.sun.jersey.impl.container.OutBoundHeaders;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerResponse
implements HttpResponseContext {
    private static final Logger LOGGER = Logger.getLogger(ContainerResponse.class.getName());
    private static final RuntimeDelegate rd = RuntimeDelegate.getInstance();
    private MessageBodyWorkers bodyContext;
    private ContainerRequest request;
    private ContainerResponseWriter responseWriter;
    private Response response;
    private int status;
    private MultivaluedMap<String, Object> headers;
    private Object entity;
    private Type entityType;
    private boolean isCommitted;
    private CommittingOutputStream out;

    public ContainerResponse(WebApplication wa, ContainerRequest request, ContainerResponseWriter responseWriter) {
        this.bodyContext = wa.getMessageBodyWorkers();
        this.request = request;
        this.responseWriter = responseWriter;
        this.status = 204;
    }

    public static String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = rd.createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    public void write() throws IOException {
        MessageBodyWriter<?> p;
        if (this.isCommitted) {
            return;
        }
        if (this.entity == null) {
            this.responseWriter.writeStatusAndHeaders(-1L, this);
            return;
        }
        MediaType contentType = this.getContentType();
        if (contentType == null) {
            List<MediaType> mts = this.bodyContext.getMessageBodyWriterMediaTypes(this.entity.getClass(), this.entityType, null);
            contentType = this.request.getAcceptableMediaType(mts);
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            this.getHttpHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((p = this.bodyContext.getMessageBodyWriter(this.entity.getClass(), this.entityType, null, contentType)) == null) {
            LOGGER.severe("A message body reader for Java type, " + this.entity.getClass() + ", and MIME media type, " + contentType + ", was not found");
            if (this.request.getMethod().equals("HEAD")) {
                this.responseWriter.writeStatusAndHeaders(-1L, this);
                return;
            }
            throw new WebApplicationException(Responses.notAcceptable().build());
        }
        long size = p.getSize(this.entity);
        if (this.request.getMethod().equals("HEAD")) {
            if (size != -1L) {
                this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(size));
            }
        } else {
            p.writeTo(this.entity, this.entity.getClass(), this.entityType, null, contentType, this.getHttpHeaders(), (OutputStream)new CommittingOutputStream(size));
        }
        if (!this.isCommitted) {
            this.responseWriter.writeStatusAndHeaders(-1L, this);
            this.isCommitted = true;
        }
    }

    public void reset() {
        this.setResponse(Responses.noContent().build());
    }

    public ContainerResponseWriter getContainerResponseWriter() {
        return this.responseWriter;
    }

    public void setContainerResponseWriter(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.setResponse(response, null);
    }

    @Override
    public void setResponse(Response r, MediaType contentType) {
        this.isCommitted = false;
        this.out = null;
        r = r != null ? r : Responses.noContent().build();
        this.response = r;
        this.status = r.getStatus();
        this.headers = r instanceof ResponseImpl ? this.setResponseOptimal((ResponseImpl)r, contentType) : this.setResponseNonOptimal(r, contentType);
    }

    @Override
    public boolean isResponseSet() {
        return this.response != null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        } else {
            this.entityType = this.entity.getClass();
        }
        this.checkStatusAndEntity();
    }

    @Override
    public MultivaluedMap<String, Object> getHttpHeaders() {
        if (this.headers == null) {
            this.headers = new OutBoundHeaders();
        }
        return this.headers;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new CommittingOutputStream(-1L);
        }
        return this.out;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    private MediaType getContentType() {
        Object mediaTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
        if (mediaTypeHeader instanceof MediaType) {
            return (MediaType)mediaTypeHeader;
        }
        if (mediaTypeHeader != null) {
            return MediaType.valueOf((String)mediaTypeHeader.toString());
        }
        return null;
    }

    private void checkStatusAndEntity() {
        if (this.status == 204 && this.entity != null) {
            this.status = 200;
        } else if (this.status == 200 && this.entity == null) {
            this.status = 204;
        }
    }

    private MultivaluedMap<String, Object> setResponseOptimal(ResponseImpl r, MediaType contentType) {
        this.entityType = r.getEntityType();
        this.entity = r.getEntity();
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        }
        return r.getMetadataOptimal(this.request, contentType);
    }

    private MultivaluedMap<String, Object> setResponseNonOptimal(Response r, MediaType contentType) {
        Object location;
        this.setEntity(r.getEntity());
        MultivaluedMap _headers = r.getMetadata();
        if (_headers.getFirst((Object)"Content-Type") == null && contentType != null) {
            _headers.putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((location = _headers.getFirst((Object)"Location")) != null && location instanceof URI) {
            URI absoluteLocation = this.request.getBaseUri().resolve((URI)location);
            _headers.putSingle((Object)"Location", (Object)absoluteLocation);
        }
        return _headers;
    }

    private final class CommittingOutputStream
    extends OutputStream {
        private final long size;
        private OutputStream o;

        CommittingOutputStream(long size) {
            this.size = size;
        }

        public void write(byte[] b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.commitWrite();
            this.o.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void flush() throws IOException {
            if (ContainerResponse.this.isCommitted) {
                this.o.flush();
            }
        }

        public void close() throws IOException {
            this.commitClose();
            this.o.close();
        }

        private void commitWrite() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                if (ContainerResponse.this.getStatus() == 204) {
                    ContainerResponse.this.setStatus(200);
                }
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(this.size, ContainerResponse.this);
            }
        }

        private void commitClose() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(-1L, ContainerResponse.this);
            }
        }
    }
}

