/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriTemplate;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriBuilderImpl
extends UriBuilder {
    private boolean encode = true;
    private String scheme;
    private String ssp;
    private String userInfo;
    private String host;
    private int port = -1;
    private final StringBuilder path;
    private final StringBuilder query;
    private String fragment;

    public UriBuilderImpl() {
        this.path = new StringBuilder();
        this.query = new StringBuilder();
    }

    private UriBuilderImpl(UriBuilderImpl that) {
        this.encode = that.encode;
        this.scheme = that.scheme;
        this.ssp = that.ssp;
        this.userInfo = that.userInfo;
        this.host = that.host;
        this.port = that.port;
        this.path = new StringBuilder(that.path);
        this.query = new StringBuilder(that.query);
        this.fragment = that.fragment;
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this);
    }

    public boolean isEncode() {
        return this.encode;
    }

    public UriBuilder encode(boolean enable) {
        this.encode = enable;
        return this;
    }

    public UriBuilder uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI parameter is null");
        }
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            if (uri.getRawUserInfo() != null) {
                this.userInfo = uri.getRawUserInfo();
            }
            if (uri.getHost() != null) {
                this.host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
                this.path.setLength(0);
                this.path.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
                this.query.setLength(0);
                this.query.append(uri.getRawQuery());
            }
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) {
        if (scheme != null) {
            this.scheme = scheme;
            UriComponent.validate(scheme, UriComponent.Type.SCHEME, true);
        } else {
            this.scheme = null;
        }
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("Scheme specific part parameter is null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (ssp != null) {
            sb.append(ssp);
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        if ((uri = this.createURI(sb.toString())).getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            this.userInfo = uri.getRawUserInfo();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path.setLength(0);
            this.path.append(this.replaceNull(uri.getRawPath()));
            this.query.setLength(0);
            this.query.append(this.replaceNull(uri.getRawQuery()));
        }
        return this;
    }

    public UriBuilder userInfo(String ui) {
        this.checkSsp();
        this.userInfo = ui != null ? this.encode(ui, UriComponent.Type.USER_INFO) : null;
        return this;
    }

    public UriBuilder host(String host) {
        this.checkSsp();
        this.host = host != null ? this.encode(host, UriComponent.Type.HOST) : null;
        return this;
    }

    public UriBuilder port(int port) {
        this.checkSsp();
        this.port = port;
        return this;
    }

    public UriBuilder replacePath(String ... segments) {
        this.checkSsp();
        this.path.setLength(0);
        this.path(segments);
        return this;
    }

    public UriBuilder extension(String extension) {
        this.checkSsp();
        throw new UnsupportedOperationException();
    }

    public UriBuilder path(String ... segments) {
        this.checkSsp();
        for (String segment : segments) {
            this.appendPath(segment);
        }
        return this;
    }

    public UriBuilder path(Class resource) {
        this.checkSsp();
        if (resource == null) {
            throw new IllegalArgumentException("Resource parameter is null");
        }
        Class c = resource;
        this.appendPath(c.getAnnotation(Path.class));
        return this;
    }

    public UriBuilder path(Class resource, String methodName) {
        this.checkSsp();
        if (resource == null) {
            throw new IllegalArgumentException("Resource parameter is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("MethodName parameter is null");
        }
        Method[] methods = resource.getMethods();
        Method found = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            if (found == null) {
                found = m;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.appendPath(found.getAnnotation(Path.class));
        return this;
    }

    public UriBuilder path(Method ... methods) {
        this.checkSsp();
        for (Method m : methods) {
            if (m == null) {
                throw new IllegalArgumentException("Method is null");
            }
            this.appendPath(m.getAnnotation(Path.class));
        }
        return this;
    }

    public UriBuilder replaceMatrixParams(String matrix) {
        this.checkSsp();
        int i = this.path.lastIndexOf("/");
        if (i != -1) {
            i = 0;
        }
        if ((i = this.path.indexOf(";", i)) != -1) {
            this.path.setLength(i + 1);
        }
        if (matrix != null) {
            this.path.append(this.encode(matrix, UriComponent.Type.PATH));
        }
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) {
        this.checkSsp();
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value parameter is null");
        }
        if (values.length == 0) {
            return this;
        }
        if (this.path.length() > 0) {
            this.path.append(';');
        }
        for (Object value : values) {
            this.path.append(this.encode(name, UriComponent.Type.PATH));
            String stringValue = value.toString();
            if (stringValue.length() <= 0) continue;
            this.path.append('=').append(this.encode(stringValue, UriComponent.Type.PATH));
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UriBuilder replaceQueryParams(String query) {
        this.checkSsp();
        this.query.setLength(0);
        if (query != null) {
            this.query.append(this.encode(query, UriComponent.Type.QUERY));
        }
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) {
        this.checkSsp();
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value parameter is null");
        }
        if (values.length == 0) {
            return this;
        }
        if (this.query.length() > 0) {
            this.query.append('&');
        }
        for (Object value : values) {
            this.query.append(this.encodeQuery(name));
            String stringValue = value.toString();
            if (stringValue.length() <= 0) continue;
            this.query.append('=').append(this.encodeQuery(stringValue));
        }
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = fragment != null ? this.encode(fragment, UriComponent.Type.FRAGMENT) : null;
        return this;
    }

    private void checkSsp() {
        if (this.ssp != null) {
            throw new IllegalArgumentException("Schema specific part is opaque");
        }
    }

    private void appendPath(Path t) {
        if (t == null) {
            throw new IllegalArgumentException("Path is null");
        }
        boolean _encode = this.encode;
        this.encode = t.encode();
        this.appendPath(t.value());
        this.encode = _encode;
    }

    private void appendPath(String segment) {
        boolean segmentStartsWithSlash;
        if (segment == null) {
            throw new IllegalArgumentException("Path segment is null");
        }
        if (segment.length() == 0) {
            return;
        }
        segment = this.encode(segment, UriComponent.Type.PATH);
        boolean pathEndsInSlash = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/';
        boolean bl = segmentStartsWithSlash = segment.charAt(0) == '/';
        if (this.path.length() > 0 && !pathEndsInSlash && !segmentStartsWithSlash) {
            this.path.append('/');
        } else if (pathEndsInSlash && segmentStartsWithSlash && (segment = segment.substring(1)).length() == 0) {
            return;
        }
        this.path.append(segment);
    }

    private String encode(String s, UriComponent.Type type) {
        if (this.encode) {
            return UriComponent.encode(s, type, true);
        }
        UriComponent.validate(s, type, true);
        return s;
    }

    private String encodeQuery(String s) {
        block3: {
            if (this.encode) {
                try {
                    return URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        UriComponent.validate(s, UriComponent.Type.QUERY, true);
        return s;
    }

    public URI build() {
        return this.createURI(this.create());
    }

    public URI build(Map<String, Object> values) {
        if (this.ssp != null) {
            throw new IllegalArgumentException("Schema specific part is opaque");
        }
        String uri = UriTemplate.createURI(this.scheme, this.userInfo, this.host, String.valueOf(this.port), this.path.toString(), this.query.toString(), this.fragment, values, this.encode);
        return this.createURI(uri);
    }

    public URI build(Object ... values) {
        if (this.ssp != null) {
            throw new IllegalArgumentException("Schema specific part is opaque");
        }
        String uri = UriTemplate.createURI(this.scheme, this.userInfo, this.host, String.valueOf(this.port), this.path.toString(), this.query.toString(), this.fragment, values, this.encode);
        return this.createURI(uri);
    }

    private String create() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.ssp != null) {
            sb.append(this.ssp);
        } else {
            if (this.userInfo != null || this.host != null || this.port != -1) {
                sb.append("//");
                if (this.userInfo != null && this.userInfo.length() > 0) {
                    sb.append(this.userInfo).append('@');
                }
                if (this.host != null) {
                    sb.append(this.host);
                }
                if (this.port != -1) {
                    sb.append(':').append(this.port);
                }
            }
            if (this.path.length() > 0) {
                if (sb.length() > 0 && this.path.charAt(0) != '/') {
                    sb.append("/");
                }
                sb.append((CharSequence)this.path);
            }
            if (this.query.length() > 0) {
                sb.append('?').append((CharSequence)this.query);
            }
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }

    private URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException((Throwable)ex);
        }
    }

    private String replaceNull(String s) {
        return s != null ? s : "";
    }

    public String getExtension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

