/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.non.blocking;

import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.client.impl.CopyOnWriteHashMap;
import com.sun.jersey.client.non.blocking.NonBlockingClient;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class NonBlockingAsyncWebResource
extends AsyncWebResource {
    private final NonBlockingClient client;

    protected NonBlockingAsyncWebResource(NonBlockingClient c, CopyOnWriteHashMap<String, Object> properties, URI u) {
        super((Client)c, properties, u);
        this.client = c;
    }

    private NonBlockingAsyncWebResource(NonBlockingAsyncWebResource that, UriBuilder ub) {
        super((AsyncWebResource)that, ub);
        this.client = that.client;
    }

    public AsyncWebResource queryParams(MultivaluedMap<String, String> params) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e : params.entrySet()) {
            for (String value : (List)e.getValue()) {
                b.queryParam((String)e.getKey(), new Object[]{value});
            }
        }
        return new NonBlockingAsyncWebResource(this, b);
    }

    public AsyncWebResource queryParam(String key, String value) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, new Object[]{value});
        return new NonBlockingAsyncWebResource(this, b);
    }

    public AsyncWebResource uri(URI uri) {
        String query;
        UriBuilder b = this.getUriBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new NonBlockingAsyncWebResource(this, b);
    }

    public AsyncWebResource path(String path) {
        return new NonBlockingAsyncWebResource(this, this.getUriBuilder().path(path));
    }

    public Future<ClientResponse> handle(ClientRequest request, final FutureListener<ClientResponse> l) {
        Request r = this.client.getRequest(request);
        try {
            final ListenableFuture listenableFuture = this.client.getClientHandlerNing().getHttpClient().executeRequest(r);
            final Future<ClientResponse> jerseyFuture = new Future<ClientResponse>(){

                @Override
                public boolean cancel(boolean b) {
                    return listenableFuture.cancel(b);
                }

                @Override
                public boolean isCancelled() {
                    return listenableFuture.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return listenableFuture.isDone();
                }

                @Override
                public ClientResponse get() throws InterruptedException, ExecutionException {
                    Response response = (Response)listenableFuture.get();
                    if (response != null) {
                        return NonBlockingAsyncWebResource.this.client.getClientResponse(response);
                    }
                    return null;
                }

                @Override
                public ClientResponse get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                    Response response = (Response)listenableFuture.get(l, timeUnit);
                    if (response != null) {
                        return NonBlockingAsyncWebResource.this.client.getClientResponse(response);
                    }
                    return null;
                }
            };
            listenableFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        l.onComplete(jerseyFuture);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    runnable.run();
                }
            });
            return jerseyFuture;
        }
        catch (IOException e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }
}

