/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.test;

import com.sun.istack.test.ForkOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntXmlFormatter
implements TestListener,
Closeable {
    private JUnitResultFormatter antf;
    private JUnitTest antTest;
    private final Class<? extends JUnitResultFormatter> formatter;
    private long startTime;
    private final File dir;
    private final PrintStream out;
    private final PrintStream err;
    private final ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errBuf = new ByteArrayOutputStream();
    private int id = 0;

    public AntXmlFormatter(Class<? extends JUnitResultFormatter> formatter, File dir) {
        this.formatter = formatter;
        this.dir = dir;
        this.out = System.out;
        this.err = System.err;
        System.setOut(new PrintStream(new ForkOutputStream(this.outBuf, this.out)));
        System.setErr(new PrintStream(new ForkOutputStream(this.errBuf, this.err)));
    }

    @Override
    public void close() {
        System.setOut(this.out);
        System.setErr(this.err);
    }

    public void addError(Test test, Throwable t) {
        this.antf.addError(test, t);
        this.antTest.setCounts(1L, 0L, 1L);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.antf.addFailure(test, t);
        this.antTest.setCounts(1L, 1L, 0L);
    }

    public void startTest(Test test) {
        assert (this.antf == null);
        try {
            this.antf = this.formatter.newInstance();
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        String testName = this.getTestName(test);
        this.antTest = new JUnitTest(testName);
        this.antTest.setCounts(1L, 0L, 0L);
        try {
            this.antf.setOutput((OutputStream)new FileOutputStream(new File(this.dir, this.getResultFileName(testName))));
        }
        catch (FileNotFoundException e) {
            throw new Error(e);
        }
        this.antf.startTestSuite(this.antTest);
        this.antf.startTest(test);
        this.outBuf.reset();
        this.errBuf.reset();
        this.startTime = System.currentTimeMillis();
    }

    private String getTestName(Test test) {
        String testName = JUnitVersionHelper.getTestCaseName((Test)test);
        if (testName == null) {
            testName = "unknown";
        }
        if (testName.indexOf(46) == -1) {
            testName = test.getClass().getPackage().getName() + "." + testName;
        }
        return testName;
    }

    private String getResultFileName(String testName) {
        StringBuilder sb = new StringBuilder(testName);
        if (sb.length() > 70) {
            sb.delete(0, sb.length() - 70);
        }
        for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (AntXmlFormatter.inRange(ch, '0', '9') || AntXmlFormatter.inRange(ch, 'a', 'z') || AntXmlFormatter.inRange(ch, 'A', 'Z') || ch == '.') continue;
            sb.setCharAt(i, '_');
        }
        sb.append('.');
        sb.append(this.id++);
        sb.append(".xml");
        return sb.toString();
    }

    private static boolean inRange(char ch, char start, char end) {
        return start <= ch && ch <= end;
    }

    public void endTest(Test test) {
        this.antf.endTest(test);
        this.antf.setSystemOutput(this.outBuf.toString());
        this.antf.setSystemError(this.errBuf.toString());
        this.antTest.setRunTime(System.currentTimeMillis() - this.startTime);
        this.antf.endTestSuite(this.antTest);
        this.antf = null;
        this.antTest = null;
    }
}

