/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.ssl.SSLOutputBuffer;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InputFilter;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.filters.BufferedInputFilter;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class SSLDefaultProcessorTask
extends DefaultProcessorTask {
    public SSLDefaultProcessorTask() {
        this(true, true);
    }

    public SSLDefaultProcessorTask(boolean init, boolean bufferResponse) {
        super(init, bufferResponse);
    }

    public void initialize() {
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new SSLOutputBuffer(this.response, this.maxHttpHeaderSize, this.bufferResponse);
        this.request.setInputBuffer(this.inputBuffer);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    public void action(ActionCode actionCode, Object param) {
        block14: {
            if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                try {
                    if (this.sslSupport == null) break block14;
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = SSLReadFilter.doPeerCertificateChain((SelectionKey)this.key, (boolean)false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                }
                catch (Exception e) {
                    SelectorThread.logger().log(Level.WARNING, "processorTask.errorSSL", e);
                }
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                if (this.sslSupport != null) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        Object[] sslO = SSLReadFilter.doPeerCertificateChain((SelectionKey)this.key, (boolean)true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                    }
                    catch (Exception e) {
                        SelectorThread.logger().log(Level.WARNING, "processorTask.exceptionSSLcert", e);
                    }
                }
            } else {
                super.action(actionCode, param);
            }
        }
    }
}

