/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.buf;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.C2BConverter;
import java.io.IOException;

class C2BConverter_8859_1
extends C2BConverter {
    protected C2BConverter_8859_1(ByteChunk bb, String enc) throws IOException {
        super(bb, enc);
    }

    public final void convert(char[] sa) throws IOException {
        this.convert(sa, 0, sa.length);
    }

    public final void convert(String s) throws IOException {
        this.convert(s.toCharArray(), 0, s.length());
    }

    public final void convert(String s, int off, int len) throws IOException {
        this.convert(s.toCharArray(), off, len);
    }

    public final void convert(char[] sa, int off, int len) throws IOException {
        int res = this.convertLoop(sa, off, len);
        while (res < len) {
            if (!this.bb.canGrow()) {
                this.bb.flushBuffer();
            }
            res = this.convertLoop(sa, off += res, len -= res);
        }
    }

    private int convertLoop(char[] sa, int sp, int len) throws IOException {
        int sl = sp + len;
        if (sl > sa.length) {
            sl = sa.length;
        }
        byte[] da = this.bb.getBytes();
        int dp = this.bb.getEnd();
        int dl = da.length - dp;
        int nChars = 0;
        while (sp < sl) {
            char c = sa[sp];
            if (c <= '\u00ff') {
                if (dp >= dl) {
                    this.bb.setEnd(dp);
                    return nChars;
                }
                da[dp++] = (byte)c;
                ++sp;
                ++nChars;
                continue;
            }
            this.bb.setEnd(dp);
            throw new IOException("Unexpected character in C2BConverter for ISO_8859_1");
        }
        this.bb.setEnd(dp);
        return nChars;
    }
}

