/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.utils.LinkedTransferQueue;
import com.sun.grizzly.utils.ObjectPool;
import com.sun.grizzly.utils.PoolableObject;

public abstract class ConcurrentQueuePool<E extends PoolableObject>
implements ObjectPool<E> {
    private final LinkedTransferQueue<E> pool = new LinkedTransferQueue();

    public abstract E newInstance();

    @Override
    public E poll() {
        PoolableObject object = (PoolableObject)this.pool.poll();
        if (object == null) {
            object = this.newInstance();
        }
        object.prepare();
        return (E)object;
    }

    @Override
    public void offer(E object) {
        object.release();
        this.pool.offer(object);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

