/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.threadpool;

import com.sun.grizzly.Context;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.IndexedAttributeHolder;
import com.sun.grizzly.memory.DefaultMemoryManager;
import com.sun.grizzly.threadpool.WorkerThread;
import java.util.concurrent.TimeUnit;

public class DefaultWorkerThread
extends Thread
implements WorkerThread {
    private final AttributeBuilder attrBuilder;
    private final AttributeHolder attributes;
    private DefaultMemoryManager.BufferInfo associatedBuffer;
    private Context cachedContext;
    private long transactionTimeoutMillis = -1L;
    private long transactionStartedTimeMillis;

    public DefaultWorkerThread(AttributeBuilder attrBuilder, String name, Runnable runTask) {
        super(runTask, name);
        this.attrBuilder = attrBuilder;
        this.attributes = this.createAttributeHolder();
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public AttributeHolder obtainAttributes() {
        return this.attributes;
    }

    public DefaultMemoryManager.BufferInfo getAssociatedBuffer() {
        return this.associatedBuffer;
    }

    public void setAssociatedBuffer(DefaultMemoryManager.BufferInfo associatedBuffer) {
        this.associatedBuffer = associatedBuffer;
    }

    public Context getCachedContext() {
        return this.cachedContext;
    }

    public void setCachedContext(Context cachedContext) {
        this.cachedContext = cachedContext;
    }

    @Override
    public long getTransactionTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTransactionTimeout(long timeout, TimeUnit timeunit) {
        this.transactionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }

    public long getTransactionStartedTime(TimeUnit timeunit) {
        return timeunit.convert(this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    protected void onBeforeRun() {
        this.transactionStartedTimeMillis = System.currentTimeMillis();
    }

    protected void onAfterRun() {
        this.transactionStartedTimeMillis = 0L;
    }

    protected AttributeHolder createAttributeHolder() {
        return new IndexedAttributeHolder(this.attrBuilder);
    }
}

