/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.filterchain.CodecFilter;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.filterchain.StreamTransformerFilter;
import com.sun.grizzly.ssl.BlockingSSLHandshaker;
import com.sun.grizzly.ssl.SSLContextConfigurator;
import com.sun.grizzly.ssl.SSLDecoderTransformer;
import com.sun.grizzly.ssl.SSLEncoderTransformer;
import com.sun.grizzly.ssl.SSLEngineConfigurator;
import com.sun.grizzly.ssl.SSLHandshaker;
import com.sun.grizzly.ssl.SSLResourcesAccessor;
import com.sun.grizzly.ssl.SSLStreamReader;
import com.sun.grizzly.ssl.SSLStreamWriter;
import com.sun.grizzly.ssl.SSLSupport;
import com.sun.grizzly.ssl.SSLSupportImpl;
import com.sun.grizzly.ssl.SSLUtils;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class SSLFilter
extends FilterAdapter
implements CodecFilter,
StreamTransformerFilter {
    private Logger logger = Grizzly.logger;
    private final SSLEngineConfigurator sslEngineConfigurator;
    private final SSLHandshaker sslHandshaker;
    private final SSLDecoderTransformer decoder;
    private final SSLEncoderTransformer encoder;

    public SSLFilter() {
        this(null);
    }

    public SSLFilter(SSLEngineConfigurator sslEngineConfigurator) {
        this(sslEngineConfigurator, null);
    }

    public SSLFilter(SSLEngineConfigurator sslEngineConfigurator, SSLHandshaker sslHandshaker) {
        if (sslEngineConfigurator == null) {
            sslEngineConfigurator = new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), false, false, false);
        }
        this.sslEngineConfigurator = sslEngineConfigurator;
        if (sslHandshaker == null) {
            sslHandshaker = new BlockingSSLHandshaker();
        }
        this.sslHandshaker = sslHandshaker;
        this.decoder = new SSLDecoderTransformer();
        this.encoder = new SSLEncoderTransformer();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Future<SSLEngine> future;
        Connection connection = ctx.getConnection();
        SSLResourcesAccessor sslResourceAccessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = sslResourceAccessor.getSSLEngine(connection);
        if (sslEngine == null) {
            sslEngine = this.sslEngineConfigurator.createSSLEngine();
            sslResourceAccessor.setSSLEngine(connection, sslEngine);
        }
        StreamReader parentReader = ctx.getStreamReader();
        StreamWriter parentWriter = ctx.getStreamWriter();
        SSLStreamReader sslStreamReader = new SSLStreamReader(parentReader);
        SSLStreamWriter sslStreamWriter = new SSLStreamWriter(parentWriter);
        ctx.setStreamReader(sslStreamReader);
        ctx.setStreamWriter(sslStreamWriter);
        sslStreamReader.pull();
        if (SSLUtils.isHandshaking(sslEngine) && !(future = this.sslHandshaker.handshake(sslStreamReader, sslStreamWriter, this.sslEngineConfigurator)).isDone()) {
            return ctx.getStopAction();
        }
        if (!sslStreamReader.hasAvailableData()) {
            nextAction = ctx.getStopAction();
        }
        return nextAction;
    }

    @Override
    public NextAction postRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        SSLStreamReader sslStreamReader = (SSLStreamReader)ctx.getStreamReader();
        SSLStreamWriter sslStreamWriter = (SSLStreamWriter)ctx.getStreamWriter();
        sslStreamReader.detach();
        ctx.setStreamReader(sslStreamReader.getUnderlyingReader());
        ctx.setStreamWriter(sslStreamWriter.getUnderlyingWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        StreamWriter writer = ctx.getStreamWriter();
        Object message = ctx.getMessage();
        if (message instanceof Buffer) {
            writer.writeBuffer((Buffer)message);
        }
        writer.flush();
        return nextAction;
    }

    @Override
    public NextAction postWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        return nextAction;
    }

    @Override
    public NextAction postClose(FilterChainContext ctx, NextAction nextAction) throws IOException {
        SSLResourcesAccessor.getInstance().clear(ctx.getConnection());
        return nextAction;
    }

    @Override
    public StreamReader getStreamReader(StreamReader parentStreamReader) {
        return new SSLStreamReader(parentStreamReader);
    }

    @Override
    public StreamWriter getStreamWriter(StreamWriter parentStreamWriter) {
        return new SSLStreamWriter(parentStreamWriter);
    }

    public SSLSupport createSSLSupport(SSLStreamReader reader, SSLStreamWriter writer) {
        return new SSLSupportImpl(this.sslEngineConfigurator, this.sslHandshaker, reader, writer);
    }

    @Override
    public Transformer getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer getEncoder() {
        return this.encoder;
    }
}

