/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class Reference<E> {
    private List<AccessibleObject> path = new LinkedList<AccessibleObject>();

    public Reference(Class root, String ref) {
        try {
            Reference.buildPath(root, ref, this.path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public E get(Object rootInstance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object currentValue = rootInstance;
        for (AccessibleObject accessor : this.path) {
            if (accessor instanceof Field) {
                currentValue = ((Field)accessor).get(currentValue);
                continue;
            }
            currentValue = ((Method)accessor).invoke(rootInstance, new Object[0]);
        }
        return (E)currentValue;
    }

    protected static void buildPath(Class root, String ref, List path) throws Exception {
        String[] steps;
        Class<?> currentClass = root;
        for (String step : steps = ref.split("/")) {
            if ((step = step.trim()).length() == 0) continue;
            try {
                Field field = currentClass.getDeclaredField(step);
                field.setAccessible(true);
                path.add(field);
                currentClass = field.getType();
            }
            catch (NoSuchFieldException fe) {
                Method method = currentClass.getDeclaredMethod(Reference.makeGetter(step), new Class[0]);
                path.add(method);
                method.setAccessible(true);
                currentClass = method.getReturnType();
            }
        }
    }

    private static String makeGetter(String field) {
        StringBuilder builder = new StringBuilder("get");
        builder.append(Character.toUpperCase(field.charAt(0)));
        if (field.length() > 1) {
            builder.append(field, 1, field.length());
        }
        return builder.toString();
    }
}

