/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.nio.transport.UDPNIOConnection;
import com.sun.grizzly.nio.transport.UDPNIOStreamReader;
import com.sun.grizzly.nio.transport.UDPNIOTransport;
import com.sun.grizzly.streams.AddressableStreamWriter;
import java.io.IOException;
import java.net.SocketAddress;

public class UDPNIOStreamTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final UDPNIOTransport transport;

    UDPNIOStreamTransportFilter(UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
        UDPNIOStreamReader reader = (UDPNIOStreamReader)connection.getStreamReader();
        ReadResult result = reader.read0();
        reader.append(result);
        if (!reader.hasAvailableData()) {
            return ctx.getStopAction();
        }
        ctx.setStreamReader(connection.getStreamReader());
        ctx.setStreamWriter(connection.getStreamWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        Object dstAddress = ctx.getAddress();
        if (message != null) {
            UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
            AddressableStreamWriter writer = (AddressableStreamWriter)connection.getStreamWriter();
            if (!connection.isConnected()) {
                writer.setPeerAddress((SocketAddress)dstAddress);
            }
            writer.writeBuffer((Buffer)message);
            writer.flush();
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

