/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorWriter;
import com.sun.grizzly.nio.transport.TCPNIOConnection;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import com.sun.grizzly.streams.AbstractStreamWriter;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class TCPNIOStreamWriter
extends AbstractStreamWriter {
    private int sentBytesCounter;

    public TCPNIOStreamWriter(TCPNIOConnection connection) {
        super(connection);
    }

    @Override
    public Future<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return super.flush(new ResetCounterCompletionHandler(completionHandler));
    }

    @Override
    protected Future<Integer> flush0(Buffer current, CompletionHandler<Integer> completionHandler) throws IOException {
        current.flip();
        TCPNIOConnection connection = (TCPNIOConnection)this.getConnection();
        TCPNIOTransport transport = (TCPNIOTransport)connection.getTransport();
        if (this.isBlocking()) {
            TemporarySelectorWriter writer = (TemporarySelectorWriter)transport.getTemporarySelectorIO().getWriter();
            Future<WriteResult<Buffer, SocketAddress>> future = writer.write(connection, null, current, new CompletionHandlerAdapter(null, completionHandler), null, this.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            try {
                return new ReadyFutureImpl<Integer>(future.get().getWrittenSize());
            }
            catch (Exception e) {
                throw new IOException("TCPNIOStreamWriter.flush0(): unexpected exception. " + e.getMessage());
            }
        }
        FutureImpl<Integer> future = new FutureImpl<Integer>();
        transport.getAsyncQueueIO().getWriter().write((Connection)connection, current, new CompletionHandlerAdapter(future, completionHandler));
        return future;
    }

    @Override
    protected Future<Integer> close0(final CompletionHandler<Integer> completionHandler) throws IOException {
        if (this.buffer != null && this.buffer.position() > 0) {
            final FutureImpl<Integer> future = new FutureImpl<Integer>();
            try {
                this.overflow(new CompletionHandler<Integer>(){

                    @Override
                    public void cancelled(Connection connection) {
                        this.close(ZERO);
                    }

                    @Override
                    public void failed(Connection connection, Throwable throwable) {
                        this.close(ZERO);
                    }

                    @Override
                    public void completed(Connection connection, Integer result) {
                        this.close(result);
                    }

                    @Override
                    public void updated(Connection connection, Integer result) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close(Integer result) {
                        try {
                            TCPNIOStreamWriter.this.getConnection().close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (completionHandler != null) {
                                completionHandler.completed(null, result);
                            }
                            future.setResult(result);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return future;
        }
        if (completionHandler != null) {
            completionHandler.completed(null, ZERO);
        }
        return new ReadyFutureImpl<Integer>(ZERO);
    }

    private final class ResetCounterCompletionHandler
    implements CompletionHandler<Integer> {
        private final CompletionHandler<Integer> parentCompletionHandler;

        public ResetCounterCompletionHandler(CompletionHandler<Integer> parentCompletionHandler) {
            this.parentCompletionHandler = parentCompletionHandler;
        }

        @Override
        public void cancelled(Connection connection) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.cancelled(connection);
            }
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.failed(connection, throwable);
            }
        }

        @Override
        public void completed(Connection connection, Integer result) {
            TCPNIOStreamWriter.this.sentBytesCounter = 0;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.completed(connection, result);
            }
        }

        @Override
        public void updated(Connection connection, Integer result) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.updated(connection, result);
            }
        }
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<WriteResult<Buffer, SocketAddress>> {
        private final FutureImpl<Integer> future;
        private final CompletionHandler<Integer> completionHandler;

        public CompletionHandlerAdapter(FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler) {
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void cancelled(Connection connection) {
            if (this.completionHandler != null) {
                this.completionHandler.cancelled(connection);
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            if (this.completionHandler != null) {
                this.completionHandler.failed(connection, throwable);
            }
            if (this.future != null) {
                this.future.failure(throwable);
            }
        }

        @Override
        public void completed(Connection connection, WriteResult result) {
            TCPNIOStreamWriter.this.sentBytesCounter += result.getWrittenSize();
            int totalSentBytes = TCPNIOStreamWriter.this.sentBytesCounter;
            if (this.completionHandler != null) {
                this.completionHandler.completed(connection, totalSentBytes);
            }
            if (this.future != null) {
                this.future.setResult(totalSentBytes);
            }
        }

        @Override
        public void updated(Connection connection, WriteResult result) {
            if (this.completionHandler != null) {
                this.completionHandler.updated(connection, TCPNIOStreamWriter.this.sentBytesCounter + result.getWrittenSize());
            }
        }
    }
}

