/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.nio.AbstractNIOConnection;
import com.sun.grizzly.nio.SelectorRunner;
import com.sun.grizzly.nio.transport.TCPNIOStreamReader;
import com.sun.grizzly.nio.transport.TCPNIOStreamWriter;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import com.sun.grizzly.utils.conditions.Condition;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPNIOConnection
extends AbstractNIOConnection {
    private Logger logger = Grizzly.logger;
    private final TCPNIOStreamReader streamReader;
    private final TCPNIOStreamWriter streamWriter;
    private SocketAddress localSocketAddress;
    private SocketAddress peerSocketAddress;

    public TCPNIOConnection(TCPNIOTransport transport, SelectableChannel channel) {
        super(transport);
        this.channel = channel;
        this.readBufferSize = transport.getReadBufferSize();
        this.writeBufferSize = transport.getWriteBufferSize();
        this.resetAddresses();
        this.streamReader = new TCPNIOStreamReader(this);
        this.streamWriter = new TCPNIOStreamWriter(this);
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    public StreamReader getStreamReader() {
        return this.streamReader;
    }

    @Override
    public StreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    @Override
    protected void preClose() {
        try {
            this.transport.fireIOEvent(IOEvent.CLOSED, this);
        }
        catch (IOException e) {
            Grizzly.logger.log(Level.FINE, "Unexpected IOExcption occurred, when firing CLOSE event");
        }
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddress;
    }

    protected void resetAddresses() {
        if (this.channel != null) {
            if (this.channel instanceof SocketChannel) {
                this.localSocketAddress = ((SocketChannel)this.channel).socket().getLocalSocketAddress();
                this.peerSocketAddress = ((SocketChannel)this.channel).socket().getRemoteSocketAddress();
            } else if (this.channel instanceof ServerSocketChannel) {
                this.localSocketAddress = ((ServerSocketChannel)this.channel).socket().getLocalSocketAddress();
                this.peerSocketAddress = null;
            }
        }
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Buffer buffer, final CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, final Condition<ReadResult<Buffer, SocketAddress>> condition) throws IOException {
        final FutureImpl<ReadResult<Buffer, SocketAddress>> future = new FutureImpl<ReadResult<Buffer, SocketAddress>>();
        final ReadResult<Buffer, SocketAddress> readResult = new ReadResult<Buffer, SocketAddress>(this, buffer, this.getPeerAddress(), 0);
        this.streamReader.notifyCondition(new Condition<StreamReader>(){

            @Override
            public boolean check(StreamReader streamReader) {
                if (condition == null) {
                    return streamReader.hasAvailableData();
                }
                readResult.setReadSize(streamReader.availableDataSize());
                return condition.check(readResult);
            }
        }, new CompletionHandler<Integer>(){

            @Override
            public void cancelled(Connection connection) {
                completionHandler.cancelled(connection);
                future.cancel(false);
            }

            @Override
            public void failed(Connection connection, Throwable throwable) {
                completionHandler.failed(connection, throwable);
                future.failure(throwable);
            }

            @Override
            public void completed(Connection connection, Integer result) {
                readResult.setReadSize(result);
                if (completionHandler != null) {
                    completionHandler.completed(connection, readResult);
                }
                future.setResult(readResult);
            }

            @Override
            public void updated(Connection connection, Integer result) {
                readResult.setReadSize(result);
                completionHandler.updated(connection, readResult);
            }
        });
        return future;
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(SocketAddress dstAddress, final Buffer buffer, final CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler) throws IOException {
        final FutureImpl<WriteResult<Buffer, SocketAddress>> future = new FutureImpl<WriteResult<Buffer, SocketAddress>>();
        this.streamWriter.writeBuffer(buffer);
        this.streamWriter.flush(new CompletionHandler<Integer>(){
            private final WriteResult<Buffer, SocketAddress> writeResult;
            {
                this.writeResult = new WriteResult<Buffer, SocketAddress>(TCPNIOConnection.this, buffer, TCPNIOConnection.this.getPeerAddress(), 0);
            }

            @Override
            public void cancelled(Connection connection) {
                completionHandler.cancelled(connection);
                future.cancel(false);
            }

            @Override
            public void failed(Connection connection, Throwable throwable) {
                completionHandler.failed(connection, throwable);
                future.failure(throwable);
            }

            @Override
            public void completed(Connection connection, Integer result) {
                this.writeResult.setWrittenSize(result);
                if (completionHandler != null) {
                    completionHandler.completed(connection, this.writeResult);
                }
                future.setResult(this.writeResult);
            }

            @Override
            public void updated(Connection connection, Integer result) {
                this.writeResult.setWrittenSize(result);
                completionHandler.updated(connection, this.writeResult);
            }
        });
        return future;
    }
}

