/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.tmpselectors;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.nio.SelectorFactory;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemporarySelectorPool {
    public static final int DEFAULT_SELECTORS_COUNT = 20;
    public long timeout = 5000L;
    private int size;
    private boolean isClosed;
    private ArrayBlockingQueue<Selector> selectors;
    private ReentrantReadWriteLock readwriteLock = new ReentrantReadWriteLock();

    public TemporarySelectorPool() {
        this(20);
    }

    public TemporarySelectorPool(int selectorsCount) {
        this.size = selectorsCount;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) throws IOException {
        this.readwriteLock.writeLock().lock();
        try {
            if (this.isClosed) {
                return;
            }
            if (this.selectors != null && this.selectors.size() != size) {
                this.reallocateQueue(size);
            }
            this.size = size;
        }
        finally {
            this.readwriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector poll() throws IOException {
        if (this.selectors == null) {
            this.initializeQueue();
        }
        this.readwriteLock.readLock().lock();
        try {
            if (this.isClosed) {
                Selector selector = null;
                return selector;
            }
            Selector selector = this.selectors.poll(this.timeout, TimeUnit.MILLISECONDS);
            return selector;
        }
        catch (InterruptedException e) {
            Selector selector = null;
            return selector;
        }
        finally {
            this.readwriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(Selector selector) {
        this.readwriteLock.readLock().lock();
        try {
            if (this.selectors == null || this.isClosed || !this.selectors.offer(selector)) {
                this.closeSelector(selector);
            }
        }
        finally {
            this.readwriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.readwriteLock.writeLock().lock();
        try {
            if (this.selectors == null) {
                return;
            }
            for (Selector selector : this.selectors) {
                this.closeSelector(selector);
            }
            this.selectors.clear();
        }
        finally {
            this.isClosed = true;
            this.selectors = null;
            this.readwriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeQueue() throws IOException {
        this.readwriteLock.writeLock().lock();
        try {
            if (!this.isClosed && this.selectors == null) {
                this.reallocateQueue(this.size);
            }
        }
        finally {
            this.readwriteLock.writeLock().unlock();
        }
    }

    private void reallocateQueue(int newSelectorsCount) throws IOException {
        ArrayBlockingQueue<Selector> newSelectors = new ArrayBlockingQueue<Selector>(newSelectorsCount);
        int newCopiedAmount = 0;
        if (this.selectors != null) {
            boolean oldHasRemainder = true;
            for (int i = 0; i < newSelectorsCount; ++i) {
                Selector toCopy = this.selectors.poll();
                if (toCopy == null) {
                    oldHasRemainder = false;
                    break;
                }
                newSelectors.add(toCopy);
                ++newCopiedAmount;
            }
            if (oldHasRemainder) {
                for (Selector selector : this.selectors) {
                    this.closeSelector(selector);
                }
            }
            this.selectors.clear();
        }
        for (int i = newCopiedAmount; i < newSelectorsCount; ++i) {
            newSelectors.add(SelectorFactory.instance().create());
        }
        this.selectors = newSelectors;
        this.size = newSelectorsCount;
    }

    private void closeSelector(Selector selector) {
        block2: {
            try {
                selector.close();
            }
            catch (IOException e) {
                Logger logger = Grizzly.logger;
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "TemporarySelectorFactory: error occurred when trying to close the Selector", e);
            }
        }
    }
}

