/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio;

import com.sun.grizzly.Transport;
import com.sun.grizzly.TransportFactory;
import com.sun.grizzly.nio.DefaultSelectionKeyHandler;
import com.sun.grizzly.nio.DefaultSelectorHandler;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.nio.SelectionKeyHandler;
import com.sun.grizzly.nio.SelectorHandler;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorPool;
import com.sun.grizzly.threadpool.ExtendedThreadPool;

public abstract class NIOTransportFactory
extends TransportFactory {
    protected SelectorHandler defaultSelectorHandler;
    protected SelectionKeyHandler defaultSelectionKeyHandler;
    protected TemporarySelectorPool defaultTemporarySelectorPool;

    public SelectorHandler getDefaultSelectorHandler() {
        return this.defaultSelectorHandler;
    }

    public void setDefaultSelectorHandler(SelectorHandler defaultSelectorHandler) {
        this.defaultSelectorHandler = defaultSelectorHandler;
    }

    public SelectionKeyHandler getDefaultSelectionKeyHandler() {
        return this.defaultSelectionKeyHandler;
    }

    public void setDefaultSelectionKeyHandler(SelectionKeyHandler defaultSelectionKeyHandler) {
        this.defaultSelectionKeyHandler = defaultSelectionKeyHandler;
    }

    public TemporarySelectorPool getDefaultTemporarySelectorPool() {
        return this.defaultTemporarySelectorPool;
    }

    public void setDefaultTemporarySelectorPool(TemporarySelectorPool defaultTemporarySelectorPool) {
        this.defaultTemporarySelectorPool = defaultTemporarySelectorPool;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.defaultSelectorHandler = new DefaultSelectorHandler();
        this.defaultSelectionKeyHandler = new DefaultSelectionKeyHandler();
        int selectorPoolSize = 20;
        if (this.defaultWorkerThreadPool instanceof ExtendedThreadPool) {
            selectorPoolSize = ((ExtendedThreadPool)((Object)this.defaultWorkerThreadPool)).getMaximumPoolSize();
        }
        this.defaultTemporarySelectorPool = new TemporarySelectorPool(selectorPoolSize);
    }

    @Override
    protected <T extends Transport> T setupTransport(T transport) {
        transport = super.setupTransport(transport);
        NIOTransport nioTransport = (NIOTransport)transport;
        nioTransport.setSelectorHandler(this.defaultSelectorHandler);
        nioTransport.setSelectionKeyHandler(this.defaultSelectionKeyHandler);
        return transport;
    }
}

