/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.memory.slab;

import com.sun.grizzly.Grizzly;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Slab {
    private static Logger logger = Grizzly.logger;
    private static boolean FINE_DEBUG = logger.isLoggable(Level.FINEST);
    private ByteBuffer space;
    private int _sizeDisposed;

    private void msg(String msg) {
        logger.log(Level.FINEST, msg);
    }

    public int currentPosition() {
        return this.space.position();
    }

    public State getState() {
        if (this.sizeAllocated() == 0) {
            return State.EMPTY;
        }
        if (this.sizeAvailable() == 0) {
            return State.FULL;
        }
        return State.PARTIAL;
    }

    public int totalSize() {
        return this.space.capacity();
    }

    public int sizeAvailable() {
        return this.space.remaining();
    }

    public int sizeAllocated() {
        return this.space.position();
    }

    public int sizeDisposed() {
        return this._sizeDisposed;
    }

    public void markFull() {
        ByteBuffer result = this.allocate(this.sizeAvailable());
        this.dispose(result);
    }

    public void markEmpty() {
        this.space.position(0);
    }

    public Slab(int size, boolean bufferType) {
        if (FINE_DEBUG) {
            this.msg("Constructor: allocating " + size + " for BufferType " + bufferType);
        }
        try {
            this.space = bufferType ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            this.initialize();
        }
        catch (Error err) {
            if (FINE_DEBUG) {
                this.msg("Error " + err + " in constructor: size = " + size + " BufferType = " + bufferType);
            }
            throw err;
        }
        catch (RuntimeException exc) {
            if (FINE_DEBUG) {
                this.msg("RuntimeException " + exc + " in constructor: size = " + size + " BufferType = " + bufferType);
            }
            throw exc;
        }
    }

    private void initialize() {
        this.space.limit(this.space.capacity());
        this.space.position(0);
        this._sizeDisposed = 0;
    }

    public ByteBuffer allocate(int size) {
        ByteBuffer result = null;
        if (size <= this.space.remaining()) {
            this.space.limit(this.space.position() + size);
            result = this.space.slice();
            this.space.position(this.space.limit());
            this.space.limit(this.space.capacity());
        }
        return result;
    }

    public void dispose(ByteBuffer buffer) {
        if (this.getState() == State.EMPTY) {
            throw new IllegalStateException("Attempt to disposed of a buffer to an empty Slab!");
        }
        this._sizeDisposed += buffer.capacity();
        if (this.getState() == State.FULL && this._sizeDisposed >= this.sizeAllocated()) {
            this.initialize();
        }
    }

    public ByteBuffer trim(int bufferStartPosition, ByteBuffer buffer, int sizeNeeded) {
        ByteBuffer result = buffer;
        if (bufferStartPosition + buffer.capacity() == this.space.position()) {
            this.space.position(bufferStartPosition);
            result = this.allocate(sizeNeeded);
        }
        return result;
    }

    public static enum State {
        EMPTY,
        PARTIAL,
        FULL;

    }
}

