/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.memory;

import com.sun.grizzly.memory.ByteBufferManager;
import com.sun.grizzly.memory.ByteBufferViewManager;
import com.sun.grizzly.memory.ByteBufferWrapper;
import com.sun.grizzly.threadpool.DefaultWorkerThread;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultMemoryManager
extends ByteBufferViewManager {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 131072;
    private int maxThreadBufferSize = 131072;
    private boolean isMonitoring;
    private AtomicLong totalBytesAllocated = new AtomicLong();

    public int getMaxThreadBufferSize() {
        return this.maxThreadBufferSize;
    }

    public void setMaxThreadBufferSize(int maxThreadBufferSize) {
        this.maxThreadBufferSize = maxThreadBufferSize;
    }

    public boolean isMonitoring() {
        return this.isMonitoring;
    }

    public void setMonitoring(boolean isMonitoring) {
        this.isMonitoring = isMonitoring;
        ByteBufferWrapper.DEBUG_MODE = isMonitoring;
    }

    public long getTotalBytesAllocated() {
        return this.totalBytesAllocated.get();
    }

    @Override
    public ByteBufferWrapper allocate(int size) {
        if (this.isDefaultWorkerThread()) {
            BufferInfo bufferInfo = this.getThreadBuffer();
            if (bufferInfo == null || bufferInfo.buffer == null) {
                return this.incAllocated(super.allocate(size));
            }
            ByteBufferWrapper allocatedFromPool = this.allocateFromPool(bufferInfo, size);
            if (allocatedFromPool != null) {
                return allocatedFromPool;
            }
            return this.incAllocated(super.allocate(size));
        }
        return this.incAllocated(super.allocate(size));
    }

    @Override
    public ByteBufferWrapper reallocate(ByteBufferWrapper oldBuffer, int newSize) {
        BufferInfo bufferInfo;
        if (oldBuffer.capacity() <= newSize) {
            return oldBuffer;
        }
        if (this.isDefaultWorkerThread() && (bufferInfo = this.getThreadBuffer()) != null && bufferInfo.buffer != null && bufferInfo.lastAllocatedBuffer == oldBuffer.visible && bufferInfo.buffer.remaining() + oldBuffer.capacity() >= newSize) {
            ByteBuffer bufferPool = bufferInfo.buffer;
            bufferPool.position(bufferPool.position() - oldBuffer.capacity());
            return this.allocateFromPool(bufferInfo, newSize);
        }
        return this.incAllocated(super.reallocate(oldBuffer, newSize));
    }

    private ByteBufferWrapper allocateFromPool(BufferInfo bufferInfo, int size) {
        if (bufferInfo == null || bufferInfo.buffer == null) {
            return null;
        }
        ByteBuffer bufferPool = bufferInfo.buffer;
        if (bufferPool.remaining() >= size) {
            ByteBuffer allocatedByteBuffer;
            if (bufferPool.position() == 0) {
                allocatedByteBuffer = bufferPool;
                bufferInfo.buffer = null;
            } else {
                allocatedByteBuffer = DefaultMemoryManager.slice(bufferPool, size);
            }
            bufferInfo.lastAllocatedBuffer = allocatedByteBuffer;
            return this.wrap(allocatedByteBuffer);
        }
        return null;
    }

    @Override
    public void release(ByteBufferWrapper buffer) {
        if (this.isDefaultWorkerThread()) {
            ByteBuffer underlyingBuffer = buffer.underlying();
            BufferInfo bufferInfo = this.getThreadBuffer();
            if (this.prepend(bufferInfo, underlyingBuffer)) {
                return;
            }
            if (bufferInfo == null || bufferInfo.buffer == null || bufferInfo.buffer.capacity() <= underlyingBuffer.capacity() && underlyingBuffer.capacity() <= this.maxThreadBufferSize) {
                boolean isNewBufferInfo = false;
                if (bufferInfo == null) {
                    bufferInfo = new BufferInfo();
                    isNewBufferInfo = true;
                }
                underlyingBuffer.clear();
                bufferInfo.buffer = underlyingBuffer;
                bufferInfo.lastAllocatedBuffer = null;
                if (isNewBufferInfo) {
                    this.setThreadBuffer(bufferInfo);
                }
                return;
            }
        }
        super.release(buffer);
    }

    public int getReadyThreadBufferSize() {
        BufferInfo bi;
        if (this.isDefaultWorkerThread() && (bi = this.getThreadBuffer()) != null && bi.buffer != null) {
            return bi.buffer.remaining();
        }
        return 0;
    }

    @Override
    public ByteBufferWrapper wrap(ByteBuffer byteBuffer) {
        return new TrimAwareWrapper(this, byteBuffer);
    }

    private BufferInfo getThreadBuffer() {
        DefaultWorkerThread workerThread = (DefaultWorkerThread)Thread.currentThread();
        return workerThread.getAssociatedBuffer();
    }

    private void setThreadBuffer(BufferInfo bufferInfo) {
        DefaultWorkerThread workerThread = (DefaultWorkerThread)Thread.currentThread();
        workerThread.setAssociatedBuffer(bufferInfo);
    }

    private ByteBufferWrapper incAllocated(ByteBufferWrapper allocated) {
        if (this.isMonitoring) {
            this.totalBytesAllocated.addAndGet(allocated.capacity());
        }
        return allocated;
    }

    private boolean prepend(BufferInfo bufferInfo, ByteBuffer underlyingBuffer) {
        if (bufferInfo != null && bufferInfo.lastAllocatedBuffer == underlyingBuffer) {
            bufferInfo.lastAllocatedBuffer = null;
            if (bufferInfo.buffer != null) {
                ByteBuffer chunk = bufferInfo.buffer;
                chunk.position(chunk.position() - underlyingBuffer.capacity());
            } else {
                bufferInfo.buffer = underlyingBuffer;
            }
            return true;
        }
        return false;
    }

    private boolean isDefaultWorkerThread() {
        return Thread.currentThread() instanceof DefaultWorkerThread;
    }

    public class TrimAwareWrapper
    extends ByteBufferWrapper {
        public TrimAwareWrapper(ByteBufferManager memoryManager, ByteBuffer underlyingByteBuffer) {
            super(memoryManager, underlyingByteBuffer);
        }

        @Override
        public void trim() {
            BufferInfo bufferInfo;
            int sizeToReturn = this.visible.capacity() - this.visible.position();
            if (sizeToReturn > 0 && DefaultMemoryManager.this.isDefaultWorkerThread() && ((bufferInfo = DefaultMemoryManager.this.getThreadBuffer()) == null || bufferInfo.lastAllocatedBuffer == this.visible)) {
                this.visible.flip();
                ByteBuffer originalByteBuffer = this.visible;
                this.visible = this.visible.slice();
                if (bufferInfo == null) {
                    originalByteBuffer.position(originalByteBuffer.limit());
                    originalByteBuffer.limit(originalByteBuffer.capacity());
                    bufferInfo = new BufferInfo();
                    bufferInfo.buffer = originalByteBuffer;
                    bufferInfo.lastAllocatedBuffer = this.visible;
                    DefaultMemoryManager.this.setThreadBuffer(bufferInfo);
                } else if (bufferInfo.lastAllocatedBuffer == originalByteBuffer) {
                    if (bufferInfo.buffer == null) {
                        originalByteBuffer.position(originalByteBuffer.limit());
                        originalByteBuffer.limit(originalByteBuffer.capacity());
                        bufferInfo.buffer = originalByteBuffer;
                    } else {
                        bufferInfo.buffer.position(bufferInfo.buffer.position() - sizeToReturn);
                    }
                    bufferInfo.lastAllocatedBuffer = this.visible;
                }
            } else {
                super.trim();
            }
        }
    }

    public class BufferInfo {
        public ByteBuffer buffer;
        public ByteBuffer lastAllocatedBuffer;

        public String toString() {
            return "(buffer=" + this.buffer + " lastAllocatedBuffer=" + this.lastAllocatedBuffer + ")";
        }
    }
}

