/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.memory;

import com.sun.grizzly.memory.ByteBufferWrapper;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.memory.WrapperAware;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteBufferManager
implements MemoryManager<ByteBufferWrapper>,
WrapperAware<ByteBufferWrapper> {
    protected boolean isDirect;

    public ByteBufferManager() {
        this(false);
    }

    public ByteBufferManager(boolean isDirect) {
        this.isDirect = isDirect;
    }

    protected ByteBuffer allocate0(int size) {
        if (this.isDirect) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    @Override
    public ByteBufferWrapper allocate(int size) {
        return this.wrap(this.allocate0(size));
    }

    @Override
    public ByteBufferWrapper reallocate(ByteBufferWrapper oldBuffer, int newSize) {
        ByteBufferWrapper newBuffer = this.allocate(newSize);
        oldBuffer.flip();
        newBuffer.put(oldBuffer);
        return newBuffer;
    }

    @Override
    public void release(ByteBufferWrapper buffer) {
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean isDirect) {
        this.isDirect = isDirect;
    }

    @Override
    public ByteBufferWrapper wrap(byte[] data) {
        return this.wrap(data, 0, data.length);
    }

    @Override
    public ByteBufferWrapper wrap(byte[] data, int offset, int length) {
        return this.wrap(ByteBuffer.wrap(data, offset, length));
    }

    @Override
    public ByteBufferWrapper wrap(String s) {
        return this.wrap(s, Charset.defaultCharset());
    }

    @Override
    public ByteBufferWrapper wrap(String s, Charset charset) {
        try {
            byte[] byteRepresentation = s.getBytes(charset.name());
            return this.wrap(byteRepresentation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ByteBufferWrapper wrap(ByteBuffer byteBuffer) {
        return new ByteBufferWrapper(this, byteBuffer);
    }
}

