/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.attributes.DefaultAttributeBuilder;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grizzly {
    private static final Pattern versionPattern = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)){1}(?:-(.+))?");
    public static Logger logger = Logger.getLogger("com.sun.grizzly");
    public static AttributeBuilder DEFAULT_ATTRIBUTE_BUILDER = new DefaultAttributeBuilder();
    private static final String dotedVersion;
    private static final int major;
    private static final int minor;

    public static void main(String[] args) {
        System.out.println(Grizzly.getDotedVersion());
    }

    public static String getDotedVersion() {
        return dotedVersion;
    }

    public static int getMajorVersion() {
        return major;
    }

    public static int getMinorVersion() {
        return minor;
    }

    public static boolean equalVersion(int major, int minor) {
        return minor == Grizzly.minor && major == Grizzly.major;
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(Grizzly.class.getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = prop.getProperty("grizzly.version");
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            dotedVersion = matcher.group(1);
            major = Integer.parseInt(matcher.group(2));
            minor = Integer.parseInt(matcher.group(3));
        } else {
            dotedVersion = "no.version";
            major = -1;
            minor = -1;
        }
    }
}

