/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Connection;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorSelector;
import com.sun.grizzly.Strategy;
import com.sun.grizzly.Transport;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.utils.ExceptionHandler;
import com.sun.grizzly.utils.LinkedTransferQueue;
import com.sun.grizzly.utils.StateHolder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public abstract class AbstractTransport
implements Transport {
    protected String name;
    protected boolean isBlocking;
    protected StateHolder<Transport.State> state;
    protected Processor processor;
    protected ProcessorSelector processorSelector;
    protected Strategy strategy;
    protected MemoryManager memoryManager;
    protected ExecutorService workerThreadPool;
    protected ExecutorService internalThreadPool;
    protected AttributeBuilder attributeBuilder;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected LinkedTransferQueue<ExceptionHandler> exceptionHandlers;

    public AbstractTransport(String name) {
        this.name = name;
        this.state = new StateHolder<Transport.State>(false, Transport.State.STOP);
        this.exceptionHandlers = new LinkedTransferQueue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public StateHolder<Transport.State> getState() {
        return this.state;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public boolean isStopped() {
        Transport.State currentState = this.state.getState();
        return currentState == Transport.State.STOP || currentState == Transport.State.STOPPING;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector selector) {
        this.processorSelector = selector;
    }

    @Override
    public Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    public void setWorkerThreadPool(ExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Override
    public ExecutorService getInternalThreadPool() {
        return this.internalThreadPool;
    }

    @Override
    public void setInternalThreadPool(ExecutorService internalThreadPool) {
        this.internalThreadPool = internalThreadPool;
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public void setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
    }

    @Override
    public void addExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    @Override
    public void removeExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    @Override
    public void notifyException(ExceptionHandler.Severity severity, Throwable throwable) {
        if (this.exceptionHandlers == null || this.exceptionHandlers.isEmpty()) {
            return;
        }
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            exceptionHandler.notifyException(severity, throwable);
        }
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection) throws IOException {
        this.fireIOEvent(ioEvent, connection, null);
    }

    protected abstract void closeConnection(Connection var1) throws IOException;

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract void stop() throws IOException;

    @Override
    public abstract void pause() throws IOException;

    @Override
    public abstract void resume() throws IOException;
}

