/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j;

import com.sumologic.http.aggregation.SumoBufferFlusher;
import com.sumologic.http.queue.BufferWithEviction;
import com.sumologic.http.queue.BufferWithFifoEviction;
import com.sumologic.http.queue.CostBoundedConcurrentQueue;
import com.sumologic.http.sender.ProxySettings;
import com.sumologic.http.sender.SumoHttpSender;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="SumoLogicAppender", category="Core", elementType="appender", printObject=true)
public class SumoLogicAppender
extends AbstractAppender {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 1000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final int DEFAULT_RETRY_INTERVAL = 10000;
    private static final long DEFAULT_MESSAGES_PER_REQUEST = 100L;
    private static final long DEFAULT_MAX_FLUSH_INTERVAL = 10000L;
    private static final long DEFAULT_FLUSHING_ACCURACY = 250L;
    private static final long DEFAULT_MAX_QUEUE_SIZE_BYTES = 1000000L;
    private static final boolean FLUSH_ALL_MESSAGES_BEFORE_STOPPING = false;
    private SumoHttpSender sender;
    private SumoBufferFlusher flusher;
    private volatile BufferWithEviction<String> queue;
    private static final Logger logger = StatusLogger.getLogger();
    private static final String CLIENT_NAME = "log4j2-appender";

    protected SumoLogicAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String url, ProxySettings proxySettings, Integer retryInterval, Integer connectionTimeout, Integer socketTimeout, Long messagesPerRequest, Long maxFlushInterval, String sourceName, String sourceCategory, String sourceHost, Long flushingAccuracy, Long maxQueueSizeBytes, Boolean flushAllBeforeStopping) {
        super(name, filter, layout, ignoreExceptions);
        this.queue = new BufferWithFifoEviction(maxQueueSizeBytes.longValue(), (CostBoundedConcurrentQueue.CostAssigner)new CostBoundedConcurrentQueue.CostAssigner<String>(){

            public long cost(String e) {
                return e.length();
            }
        });
        this.sender = new SumoHttpSender();
        this.sender.setRetryInterval((long)retryInterval.intValue());
        this.sender.setConnectionTimeout(connectionTimeout.intValue());
        this.sender.setSocketTimeout(socketTimeout.intValue());
        this.sender.setUrl(url);
        this.sender.setSourceName(sourceName);
        this.sender.setSourceCategory(sourceCategory);
        this.sender.setSourceHost(sourceHost);
        this.sender.setProxySettings(proxySettings);
        this.sender.setClientHeaderValue(CLIENT_NAME);
        this.sender.init();
        this.flusher = new SumoBufferFlusher(flushingAccuracy.longValue(), messagesPerRequest.longValue(), maxFlushInterval.longValue(), this.sender, this.queue, flushAllBeforeStopping.booleanValue());
        this.flusher.start();
    }

    @PluginFactory
    public static SumoLogicAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="url") String url, @PluginAttribute(value="proxyAuth") String proxyAuth, @PluginAttribute(value="proxyHost") String proxyHost, @PluginAttribute(value="proxyPort") Integer proxyPort, @PluginAttribute(value="proxyUser") String proxyUser, @PluginAttribute(value="proxyPassword") String proxyPassword, @PluginAttribute(value="proxyDomain") String proxyDomain, @PluginAttribute(value="retryInterval", defaultInt=10000) Integer retryInterval, @PluginAttribute(value="connectionTimeout", defaultInt=1000) Integer connectionTimeout, @PluginAttribute(value="socketTimeout", defaultInt=60000) Integer socketTimeout, @PluginAttribute(value="messagesPerRequest", defaultLong=100L) Long messagesPerRequest, @PluginAttribute(value="maxFlushInterval", defaultLong=10000L) Long maxFlushInterval, @PluginAttribute(value="sourceName") String sourceName, @PluginAttribute(value="sourceCategory") String sourceCategory, @PluginAttribute(value="sourceHost") String sourceHost, @PluginAttribute(value="flushingAccuracy", defaultLong=250L) Long flushingAccuracy, @PluginAttribute(value="maxQueueSizeBytes", defaultLong=1000000L) Long maxQueueSizeBytes, @PluginAttribute(value="flushAllBeforeStopping", defaultBoolean=false) Boolean flushAllBeforeStopping) {
        if (name == null) {
            logger.error("No name provided for SumoLogicAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (url == null) {
            logger.error("No url provided for SumoLogicAppender");
            return null;
        }
        ProxySettings proxySettings = new ProxySettings(proxyHost, proxyPort, proxyAuth, proxyUser, proxyPassword, proxyDomain);
        return new SumoLogicAppender(name, filter, (Layout<? extends Serializable>)layout, true, url, proxySettings, retryInterval, connectionTimeout, socketTimeout, messagesPerRequest, maxFlushInterval, sourceName, sourceCategory, sourceHost, flushingAccuracy, maxQueueSizeBytes, flushAllBeforeStopping);
    }

    public void append(LogEvent event) {
        if (!this.checkEntryConditions()) {
            logger.warn("Appender not initialized. Dropping log entry");
            return;
        }
        String message = new String(this.getLayout().toByteArray(event));
        logger.debug("Sending message to Sumo: " + message);
        try {
            this.queue.add((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to insert log entry into log queue. ", (Throwable)e);
        }
    }

    public void setSourceName(String sourceName) {
        if (this.sender != null) {
            this.sender.setSourceName(sourceName);
        }
    }

    public void setSourceCategory(String sourceCategory) {
        if (this.sender != null) {
            this.sender.setSourceCategory(sourceCategory);
        }
    }

    public void setUrl(String url) {
        if (this.sender != null) {
            this.sender.setUrl(url);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        logger.debug("Stopping SumoLogicAppender {}", (Object)this.getName());
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        try {
            this.flusher.stop();
            logger.debug("flusher has been stopped");
            this.flusher = null;
            this.sender.close();
            this.sender = null;
        }
        catch (Exception e) {
            logger.error("Unable to close appender", (Throwable)e);
        }
        this.setStopped();
        logger.debug("SumoLogicAppender {} has been stopped", (Object)this.getName());
        return stopped;
    }

    private boolean checkEntryConditions() {
        return this.sender != null && this.sender.isInitialized();
    }
}

