/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.http;

import com.sumologic.log4j.aggregation.BufferFlushingTask;
import com.sumologic.log4j.http.SumoHttpSender;
import com.sumologic.log4j.queue.BufferWithEviction;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumoBufferFlushingTask
extends BufferFlushingTask<String, String> {
    private static final Logger logger = StatusLogger.getLogger();
    private SumoHttpSender sender;
    private long maxFlushInterval;
    private long messagesPerRequest;
    private String name;

    public SumoBufferFlushingTask(BufferWithEviction<String> queue) {
        super(queue);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSender(SumoHttpSender sender) {
        this.sender = sender;
    }

    public void setMessagesPerRequest(long messagesPerRequest) {
        this.messagesPerRequest = messagesPerRequest;
    }

    public void setMaxFlushInterval(long maxFlushInterval) {
        this.maxFlushInterval = maxFlushInterval;
    }

    @Override
    protected long getMaxFlushInterval() {
        return this.maxFlushInterval;
    }

    @Override
    protected long getMessagesPerRequest() {
        return this.messagesPerRequest;
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    protected String aggregate(List<String> messages) {
        StringBuilder builder = new StringBuilder(messages.size() * 10);
        for (String message : messages) {
            builder.append(message);
        }
        return builder.toString();
    }

    @Override
    protected void sendOut(String body, String name) {
        if (this.sender != null && this.sender.isInitialized()) {
            logger.debug("Sending out data");
            this.sender.send(body, name);
        } else {
            logger.error("HTTPSender is not initialized");
        }
    }
}

