/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;

final class CanonicalNameGenerator {
    private static final String CUSTOM_ELEMENT_TYPE = "Custom://";
    private static final String PERSON_TYPE = "Person://";
    private static final String SOFTWARE_SYSTEM_TYPE = "SoftwareSystem://";
    private static final String CONTAINER_TYPE = "Container://";
    private static final String COMPONENT_TYPE = "Component://";
    private static final String DEPLOYMENT_NODE_TYPE = "DeploymentNode://";
    private static final String INFRASTRUCTURE_NODE_TYPE = "InfrastructureNode://";
    private static final String CONTAINER_INSTANCE_TYPE = "ContainerInstance://";
    private static final String SOFTWARE_SYSTEM_INSTANCE_TYPE = "SoftwareSystemInstance://";
    private static final String STATIC_CANONICAL_NAME_SEPARATOR = ".";
    private static final String DEPLOYMENT_CANONICAL_NAME_SEPARATOR = "/";
    private static final String RELATIONSHIP_TYPE = "Relationship://";

    CanonicalNameGenerator() {
    }

    private String formatName(Element element) {
        return this.formatName(element.getName());
    }

    private String formatName(String name) {
        return name.replace(STATIC_CANONICAL_NAME_SEPARATOR, "").replace(DEPLOYMENT_CANONICAL_NAME_SEPARATOR, "");
    }

    String generate(CustomElement customElement) {
        return CUSTOM_ELEMENT_TYPE + this.formatName(customElement);
    }

    String generate(Person person) {
        return PERSON_TYPE + this.formatName(person);
    }

    String generate(SoftwareSystem softwareSystem) {
        return SOFTWARE_SYSTEM_TYPE + this.formatName(softwareSystem);
    }

    String generate(Container container) {
        return CONTAINER_TYPE + this.formatName(container.getSoftwareSystem()) + STATIC_CANONICAL_NAME_SEPARATOR + this.formatName(container);
    }

    String generate(Component component) {
        return COMPONENT_TYPE + this.formatName(component.getContainer().getSoftwareSystem()) + STATIC_CANONICAL_NAME_SEPARATOR + this.formatName(component.getContainer()) + STATIC_CANONICAL_NAME_SEPARATOR + this.formatName(component);
    }

    String generate(DeploymentNode deploymentNode) {
        StringBuilder buf = new StringBuilder();
        buf.append(DEPLOYMENT_NODE_TYPE);
        buf.append(this.formatName(deploymentNode.getEnvironment()));
        buf.append(DEPLOYMENT_CANONICAL_NAME_SEPARATOR);
        Object parents = "";
        for (DeploymentNode parent = (DeploymentNode)deploymentNode.getParent(); parent != null; parent = (DeploymentNode)parent.getParent()) {
            parents = this.formatName(parent) + DEPLOYMENT_CANONICAL_NAME_SEPARATOR + (String)parents;
        }
        buf.append((String)parents);
        buf.append(this.formatName(deploymentNode));
        return buf.toString();
    }

    String generate(InfrastructureNode infrastructureNode) {
        String deploymentNodeCanonicalName = this.generate((DeploymentNode)infrastructureNode.getParent()).substring(DEPLOYMENT_NODE_TYPE.length());
        return INFRASTRUCTURE_NODE_TYPE + deploymentNodeCanonicalName + DEPLOYMENT_CANONICAL_NAME_SEPARATOR + this.formatName(infrastructureNode);
    }

    String generate(SoftwareSystemInstance softwareSystemInstance) {
        String deploymentNodeCanonicalName = this.generate((DeploymentNode)softwareSystemInstance.getParent()).substring(DEPLOYMENT_NODE_TYPE.length());
        return SOFTWARE_SYSTEM_INSTANCE_TYPE + deploymentNodeCanonicalName + DEPLOYMENT_CANONICAL_NAME_SEPARATOR + this.formatName(softwareSystemInstance.getSoftwareSystem()) + "[" + softwareSystemInstance.getInstanceId() + "]";
    }

    String generate(ContainerInstance containerInstance) {
        String deploymentNodeCanonicalName = this.generate((DeploymentNode)containerInstance.getParent()).substring(DEPLOYMENT_NODE_TYPE.length());
        return CONTAINER_INSTANCE_TYPE + deploymentNodeCanonicalName + DEPLOYMENT_CANONICAL_NAME_SEPARATOR + this.generate(containerInstance.getContainer()).substring(CONTAINER_TYPE.length()) + "[" + containerInstance.getInstanceId() + "]";
    }

    String generate(Relationship relationship) {
        if (StringUtils.isNullOrEmpty(relationship.getDescription())) {
            return RELATIONSHIP_TYPE + relationship.getSource().getCanonicalName() + " -> " + relationship.getDestination().getCanonicalName();
        }
        return RELATIONSHIP_TYPE + relationship.getSource().getCanonicalName() + " -> " + relationship.getDestination().getCanonicalName() + " (" + relationship.getDescription() + ")";
    }
}

