/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.terminal;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.terminal.Location;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.LocationCreateParams;
import com.stripe.param.terminal.LocationListParams;
import com.stripe.param.terminal.LocationRetrieveParams;
import com.stripe.param.terminal.LocationUpdateParams;
import java.lang.reflect.Type;

public final class LocationService
extends ApiService {
    public LocationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Location delete(String location) throws StripeException {
        return this.delete(location, null);
    }

    public Location delete(String location, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (Location)this.request(request, (Type)((Object)Location.class));
    }

    public Location retrieve(String location, LocationRetrieveParams params) throws StripeException {
        return this.retrieve(location, params, null);
    }

    public Location retrieve(String location, RequestOptions options) throws StripeException {
        return this.retrieve(location, null, options);
    }

    public Location retrieve(String location) throws StripeException {
        return this.retrieve(location, null, null);
    }

    public Location retrieve(String location, LocationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)this.request(request, (Type)((Object)Location.class));
    }

    public Location update(String location, LocationUpdateParams params) throws StripeException {
        return this.update(location, params, null);
    }

    public Location update(String location, RequestOptions options) throws StripeException {
        return this.update(location, null, options);
    }

    public Location update(String location) throws StripeException {
        return this.update(location, null, null);
    }

    public Location update(String location, LocationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)this.request(request, (Type)((Object)Location.class));
    }

    public StripeCollection<Location> list(LocationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Location> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Location> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Location> list(LocationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Location>>(){}.getType());
    }

    public Location create(LocationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Location create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Location create() throws StripeException {
        return this.create(null, null);
    }

    public Location create(LocationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Location)this.request(request, (Type)((Object)Location.class));
    }
}

