/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.terminal.ConfigurationCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.ConfigurationCreateParams;
import com.stripe.param.terminal.ConfigurationListParams;
import com.stripe.param.terminal.ConfigurationRetrieveParams;
import com.stripe.param.terminal.ConfigurationUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Configuration
extends ApiResource
implements HasId {
    @SerializedName(value="bbpos_wisepad3")
    BbposWisepad3 bbposWisepad3;
    @SerializedName(value="bbpos_wisepos_e")
    BbposWiseposE bbposWiseposE;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_account_default")
    Boolean isAccountDefault;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="offline")
    Offline offline;
    @SerializedName(value="reboot_window")
    RebootWindow rebootWindow;
    @SerializedName(value="stripe_s700")
    StripeS700 stripeS700;
    @SerializedName(value="tipping")
    Tipping tipping;
    @SerializedName(value="verifone_p400")
    VerifoneP400 verifoneP400;
    @SerializedName(value="wifi")
    Wifi wifi;

    public static Configuration create(Map<String, Object> params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Configuration)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public static Configuration create(ConfigurationCreateParams params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Configuration)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public Configuration delete() throws StripeException {
        return this.delete(null, null);
    }

    public Configuration delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Configuration delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Configuration delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public static ConfigurationCollection list(Map<String, Object> params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (ConfigurationCollection)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)ConfigurationCollection.class));
    }

    public static ConfigurationCollection list(ConfigurationListParams params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(ConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (ConfigurationCollection)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)ConfigurationCollection.class));
    }

    public static Configuration retrieve(String configuration) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, options);
    }

    public static Configuration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Configuration)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public static Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Configuration)Configuration.getGlobalResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public Configuration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Configuration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public Configuration update(ConfigurationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Configuration update(ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.bbposWisepad3, responseGetter);
        this.trySetResponseGetter(this.bbposWiseposE, responseGetter);
        this.trySetResponseGetter(this.offline, responseGetter);
        this.trySetResponseGetter(this.rebootWindow, responseGetter);
        this.trySetResponseGetter(this.stripeS700, responseGetter);
        this.trySetResponseGetter(this.tipping, responseGetter);
        this.trySetResponseGetter(this.verifoneP400, responseGetter);
        this.trySetResponseGetter(this.wifi, responseGetter);
    }

    @Generated
    public BbposWisepad3 getBbposWisepad3() {
        return this.bbposWisepad3;
    }

    @Generated
    public BbposWiseposE getBbposWiseposE() {
        return this.bbposWiseposE;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getIsAccountDefault() {
        return this.isAccountDefault;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Offline getOffline() {
        return this.offline;
    }

    @Generated
    public RebootWindow getRebootWindow() {
        return this.rebootWindow;
    }

    @Generated
    public StripeS700 getStripeS700() {
        return this.stripeS700;
    }

    @Generated
    public Tipping getTipping() {
        return this.tipping;
    }

    @Generated
    public VerifoneP400 getVerifoneP400() {
        return this.verifoneP400;
    }

    @Generated
    public Wifi getWifi() {
        return this.wifi;
    }

    @Generated
    public void setBbposWisepad3(BbposWisepad3 bbposWisepad3) {
        this.bbposWisepad3 = bbposWisepad3;
    }

    @Generated
    public void setBbposWiseposE(BbposWiseposE bbposWiseposE) {
        this.bbposWiseposE = bbposWiseposE;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsAccountDefault(Boolean isAccountDefault) {
        this.isAccountDefault = isAccountDefault;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOffline(Offline offline) {
        this.offline = offline;
    }

    @Generated
    public void setRebootWindow(RebootWindow rebootWindow) {
        this.rebootWindow = rebootWindow;
    }

    @Generated
    public void setStripeS700(StripeS700 stripeS700) {
        this.stripeS700 = stripeS700;
    }

    @Generated
    public void setTipping(Tipping tipping) {
        this.tipping = tipping;
    }

    @Generated
    public void setVerifoneP400(VerifoneP400 verifoneP400) {
        this.verifoneP400 = verifoneP400;
    }

    @Generated
    public void setWifi(Wifi wifi) {
        this.wifi = wifi;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$isAccountDefault = this.getIsAccountDefault();
        Boolean other$isAccountDefault = other.getIsAccountDefault();
        if (this$isAccountDefault == null ? other$isAccountDefault != null : !((Object)this$isAccountDefault).equals(other$isAccountDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        BbposWisepad3 this$bbposWisepad3 = this.getBbposWisepad3();
        BbposWisepad3 other$bbposWisepad3 = other.getBbposWisepad3();
        if (this$bbposWisepad3 == null ? other$bbposWisepad3 != null : !((Object)this$bbposWisepad3).equals(other$bbposWisepad3)) {
            return false;
        }
        BbposWiseposE this$bbposWiseposE = this.getBbposWiseposE();
        BbposWiseposE other$bbposWiseposE = other.getBbposWiseposE();
        if (this$bbposWiseposE == null ? other$bbposWiseposE != null : !((Object)this$bbposWiseposE).equals(other$bbposWiseposE)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Offline this$offline = this.getOffline();
        Offline other$offline = other.getOffline();
        if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
            return false;
        }
        RebootWindow this$rebootWindow = this.getRebootWindow();
        RebootWindow other$rebootWindow = other.getRebootWindow();
        if (this$rebootWindow == null ? other$rebootWindow != null : !((Object)this$rebootWindow).equals(other$rebootWindow)) {
            return false;
        }
        StripeS700 this$stripeS700 = this.getStripeS700();
        StripeS700 other$stripeS700 = other.getStripeS700();
        if (this$stripeS700 == null ? other$stripeS700 != null : !((Object)this$stripeS700).equals(other$stripeS700)) {
            return false;
        }
        Tipping this$tipping = this.getTipping();
        Tipping other$tipping = other.getTipping();
        if (this$tipping == null ? other$tipping != null : !((Object)this$tipping).equals(other$tipping)) {
            return false;
        }
        VerifoneP400 this$verifoneP400 = this.getVerifoneP400();
        VerifoneP400 other$verifoneP400 = other.getVerifoneP400();
        if (this$verifoneP400 == null ? other$verifoneP400 != null : !((Object)this$verifoneP400).equals(other$verifoneP400)) {
            return false;
        }
        Wifi this$wifi = this.getWifi();
        Wifi other$wifi = other.getWifi();
        return !(this$wifi == null ? other$wifi != null : !((Object)this$wifi).equals(other$wifi));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $isAccountDefault = this.getIsAccountDefault();
        result = result * 59 + ($isAccountDefault == null ? 43 : ((Object)$isAccountDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        BbposWisepad3 $bbposWisepad3 = this.getBbposWisepad3();
        result = result * 59 + ($bbposWisepad3 == null ? 43 : ((Object)$bbposWisepad3).hashCode());
        BbposWiseposE $bbposWiseposE = this.getBbposWiseposE();
        result = result * 59 + ($bbposWiseposE == null ? 43 : ((Object)$bbposWiseposE).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Offline $offline = this.getOffline();
        result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
        RebootWindow $rebootWindow = this.getRebootWindow();
        result = result * 59 + ($rebootWindow == null ? 43 : ((Object)$rebootWindow).hashCode());
        StripeS700 $stripeS700 = this.getStripeS700();
        result = result * 59 + ($stripeS700 == null ? 43 : ((Object)$stripeS700).hashCode());
        Tipping $tipping = this.getTipping();
        result = result * 59 + ($tipping == null ? 43 : ((Object)$tipping).hashCode());
        VerifoneP400 $verifoneP400 = this.getVerifoneP400();
        result = result * 59 + ($verifoneP400 == null ? 43 : ((Object)$verifoneP400).hashCode());
        Wifi $wifi = this.getWifi();
        result = result * 59 + ($wifi == null ? 43 : ((Object)$wifi).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class BbposWisepad3
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BbposWisepad3)) {
                return false;
            }
            BbposWisepad3 other = (BbposWisepad3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BbposWisepad3;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }

    public static class BbposWiseposE
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BbposWiseposE)) {
                return false;
            }
            BbposWiseposE other = (BbposWiseposE)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BbposWiseposE;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }

    public static class Offline
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Offline)) {
                return false;
            }
            Offline other = (Offline)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Offline;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class RebootWindow
    extends StripeObject {
        @SerializedName(value="end_hour")
        Long endHour;
        @SerializedName(value="start_hour")
        Long startHour;

        @Generated
        public Long getEndHour() {
            return this.endHour;
        }

        @Generated
        public Long getStartHour() {
            return this.startHour;
        }

        @Generated
        public void setEndHour(Long endHour) {
            this.endHour = endHour;
        }

        @Generated
        public void setStartHour(Long startHour) {
            this.startHour = startHour;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RebootWindow)) {
                return false;
            }
            RebootWindow other = (RebootWindow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endHour = this.getEndHour();
            Long other$endHour = other.getEndHour();
            if (this$endHour == null ? other$endHour != null : !((Object)this$endHour).equals(other$endHour)) {
                return false;
            }
            Long this$startHour = this.getStartHour();
            Long other$startHour = other.getStartHour();
            return !(this$startHour == null ? other$startHour != null : !((Object)this$startHour).equals(other$startHour));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RebootWindow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endHour = this.getEndHour();
            result = result * 59 + ($endHour == null ? 43 : ((Object)$endHour).hashCode());
            Long $startHour = this.getStartHour();
            result = result * 59 + ($startHour == null ? 43 : ((Object)$startHour).hashCode());
            return result;
        }
    }

    public static class StripeS700
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StripeS700)) {
                return false;
            }
            StripeS700 other = (StripeS700)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StripeS700;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }

    public static class Tipping
    extends StripeObject {
        @SerializedName(value="aed")
        Aed aed;
        @SerializedName(value="aud")
        Aud aud;
        @SerializedName(value="bgn")
        Bgn bgn;
        @SerializedName(value="cad")
        Cad cad;
        @SerializedName(value="chf")
        Chf chf;
        @SerializedName(value="czk")
        Czk czk;
        @SerializedName(value="dkk")
        Dkk dkk;
        @SerializedName(value="eur")
        Eur eur;
        @SerializedName(value="gbp")
        Gbp gbp;
        @SerializedName(value="gip")
        Gip gip;
        @SerializedName(value="hkd")
        Hkd hkd;
        @SerializedName(value="huf")
        Huf huf;
        @SerializedName(value="jpy")
        Jpy jpy;
        @SerializedName(value="mxn")
        Mxn mxn;
        @SerializedName(value="myr")
        Myr myr;
        @SerializedName(value="nok")
        Nok nok;
        @SerializedName(value="nzd")
        Nzd nzd;
        @SerializedName(value="pln")
        Pln pln;
        @SerializedName(value="ron")
        Ron ron;
        @SerializedName(value="sek")
        Sek sek;
        @SerializedName(value="sgd")
        Sgd sgd;
        @SerializedName(value="usd")
        Usd usd;

        @Generated
        public Aed getAed() {
            return this.aed;
        }

        @Generated
        public Aud getAud() {
            return this.aud;
        }

        @Generated
        public Bgn getBgn() {
            return this.bgn;
        }

        @Generated
        public Cad getCad() {
            return this.cad;
        }

        @Generated
        public Chf getChf() {
            return this.chf;
        }

        @Generated
        public Czk getCzk() {
            return this.czk;
        }

        @Generated
        public Dkk getDkk() {
            return this.dkk;
        }

        @Generated
        public Eur getEur() {
            return this.eur;
        }

        @Generated
        public Gbp getGbp() {
            return this.gbp;
        }

        @Generated
        public Gip getGip() {
            return this.gip;
        }

        @Generated
        public Hkd getHkd() {
            return this.hkd;
        }

        @Generated
        public Huf getHuf() {
            return this.huf;
        }

        @Generated
        public Jpy getJpy() {
            return this.jpy;
        }

        @Generated
        public Mxn getMxn() {
            return this.mxn;
        }

        @Generated
        public Myr getMyr() {
            return this.myr;
        }

        @Generated
        public Nok getNok() {
            return this.nok;
        }

        @Generated
        public Nzd getNzd() {
            return this.nzd;
        }

        @Generated
        public Pln getPln() {
            return this.pln;
        }

        @Generated
        public Ron getRon() {
            return this.ron;
        }

        @Generated
        public Sek getSek() {
            return this.sek;
        }

        @Generated
        public Sgd getSgd() {
            return this.sgd;
        }

        @Generated
        public Usd getUsd() {
            return this.usd;
        }

        @Generated
        public void setAed(Aed aed) {
            this.aed = aed;
        }

        @Generated
        public void setAud(Aud aud) {
            this.aud = aud;
        }

        @Generated
        public void setBgn(Bgn bgn) {
            this.bgn = bgn;
        }

        @Generated
        public void setCad(Cad cad) {
            this.cad = cad;
        }

        @Generated
        public void setChf(Chf chf) {
            this.chf = chf;
        }

        @Generated
        public void setCzk(Czk czk) {
            this.czk = czk;
        }

        @Generated
        public void setDkk(Dkk dkk) {
            this.dkk = dkk;
        }

        @Generated
        public void setEur(Eur eur) {
            this.eur = eur;
        }

        @Generated
        public void setGbp(Gbp gbp) {
            this.gbp = gbp;
        }

        @Generated
        public void setGip(Gip gip) {
            this.gip = gip;
        }

        @Generated
        public void setHkd(Hkd hkd) {
            this.hkd = hkd;
        }

        @Generated
        public void setHuf(Huf huf) {
            this.huf = huf;
        }

        @Generated
        public void setJpy(Jpy jpy) {
            this.jpy = jpy;
        }

        @Generated
        public void setMxn(Mxn mxn) {
            this.mxn = mxn;
        }

        @Generated
        public void setMyr(Myr myr) {
            this.myr = myr;
        }

        @Generated
        public void setNok(Nok nok) {
            this.nok = nok;
        }

        @Generated
        public void setNzd(Nzd nzd) {
            this.nzd = nzd;
        }

        @Generated
        public void setPln(Pln pln) {
            this.pln = pln;
        }

        @Generated
        public void setRon(Ron ron) {
            this.ron = ron;
        }

        @Generated
        public void setSek(Sek sek) {
            this.sek = sek;
        }

        @Generated
        public void setSgd(Sgd sgd) {
            this.sgd = sgd;
        }

        @Generated
        public void setUsd(Usd usd) {
            this.usd = usd;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tipping)) {
                return false;
            }
            Tipping other = (Tipping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Aed this$aed = this.getAed();
            Aed other$aed = other.getAed();
            if (this$aed == null ? other$aed != null : !((Object)this$aed).equals(other$aed)) {
                return false;
            }
            Aud this$aud = this.getAud();
            Aud other$aud = other.getAud();
            if (this$aud == null ? other$aud != null : !((Object)this$aud).equals(other$aud)) {
                return false;
            }
            Bgn this$bgn = this.getBgn();
            Bgn other$bgn = other.getBgn();
            if (this$bgn == null ? other$bgn != null : !((Object)this$bgn).equals(other$bgn)) {
                return false;
            }
            Cad this$cad = this.getCad();
            Cad other$cad = other.getCad();
            if (this$cad == null ? other$cad != null : !((Object)this$cad).equals(other$cad)) {
                return false;
            }
            Chf this$chf = this.getChf();
            Chf other$chf = other.getChf();
            if (this$chf == null ? other$chf != null : !((Object)this$chf).equals(other$chf)) {
                return false;
            }
            Czk this$czk = this.getCzk();
            Czk other$czk = other.getCzk();
            if (this$czk == null ? other$czk != null : !((Object)this$czk).equals(other$czk)) {
                return false;
            }
            Dkk this$dkk = this.getDkk();
            Dkk other$dkk = other.getDkk();
            if (this$dkk == null ? other$dkk != null : !((Object)this$dkk).equals(other$dkk)) {
                return false;
            }
            Eur this$eur = this.getEur();
            Eur other$eur = other.getEur();
            if (this$eur == null ? other$eur != null : !((Object)this$eur).equals(other$eur)) {
                return false;
            }
            Gbp this$gbp = this.getGbp();
            Gbp other$gbp = other.getGbp();
            if (this$gbp == null ? other$gbp != null : !((Object)this$gbp).equals(other$gbp)) {
                return false;
            }
            Gip this$gip = this.getGip();
            Gip other$gip = other.getGip();
            if (this$gip == null ? other$gip != null : !((Object)this$gip).equals(other$gip)) {
                return false;
            }
            Hkd this$hkd = this.getHkd();
            Hkd other$hkd = other.getHkd();
            if (this$hkd == null ? other$hkd != null : !((Object)this$hkd).equals(other$hkd)) {
                return false;
            }
            Huf this$huf = this.getHuf();
            Huf other$huf = other.getHuf();
            if (this$huf == null ? other$huf != null : !((Object)this$huf).equals(other$huf)) {
                return false;
            }
            Jpy this$jpy = this.getJpy();
            Jpy other$jpy = other.getJpy();
            if (this$jpy == null ? other$jpy != null : !((Object)this$jpy).equals(other$jpy)) {
                return false;
            }
            Mxn this$mxn = this.getMxn();
            Mxn other$mxn = other.getMxn();
            if (this$mxn == null ? other$mxn != null : !((Object)this$mxn).equals(other$mxn)) {
                return false;
            }
            Myr this$myr = this.getMyr();
            Myr other$myr = other.getMyr();
            if (this$myr == null ? other$myr != null : !((Object)this$myr).equals(other$myr)) {
                return false;
            }
            Nok this$nok = this.getNok();
            Nok other$nok = other.getNok();
            if (this$nok == null ? other$nok != null : !((Object)this$nok).equals(other$nok)) {
                return false;
            }
            Nzd this$nzd = this.getNzd();
            Nzd other$nzd = other.getNzd();
            if (this$nzd == null ? other$nzd != null : !((Object)this$nzd).equals(other$nzd)) {
                return false;
            }
            Pln this$pln = this.getPln();
            Pln other$pln = other.getPln();
            if (this$pln == null ? other$pln != null : !((Object)this$pln).equals(other$pln)) {
                return false;
            }
            Ron this$ron = this.getRon();
            Ron other$ron = other.getRon();
            if (this$ron == null ? other$ron != null : !((Object)this$ron).equals(other$ron)) {
                return false;
            }
            Sek this$sek = this.getSek();
            Sek other$sek = other.getSek();
            if (this$sek == null ? other$sek != null : !((Object)this$sek).equals(other$sek)) {
                return false;
            }
            Sgd this$sgd = this.getSgd();
            Sgd other$sgd = other.getSgd();
            if (this$sgd == null ? other$sgd != null : !((Object)this$sgd).equals(other$sgd)) {
                return false;
            }
            Usd this$usd = this.getUsd();
            Usd other$usd = other.getUsd();
            return !(this$usd == null ? other$usd != null : !((Object)this$usd).equals(other$usd));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tipping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Aed $aed = this.getAed();
            result = result * 59 + ($aed == null ? 43 : ((Object)$aed).hashCode());
            Aud $aud = this.getAud();
            result = result * 59 + ($aud == null ? 43 : ((Object)$aud).hashCode());
            Bgn $bgn = this.getBgn();
            result = result * 59 + ($bgn == null ? 43 : ((Object)$bgn).hashCode());
            Cad $cad = this.getCad();
            result = result * 59 + ($cad == null ? 43 : ((Object)$cad).hashCode());
            Chf $chf = this.getChf();
            result = result * 59 + ($chf == null ? 43 : ((Object)$chf).hashCode());
            Czk $czk = this.getCzk();
            result = result * 59 + ($czk == null ? 43 : ((Object)$czk).hashCode());
            Dkk $dkk = this.getDkk();
            result = result * 59 + ($dkk == null ? 43 : ((Object)$dkk).hashCode());
            Eur $eur = this.getEur();
            result = result * 59 + ($eur == null ? 43 : ((Object)$eur).hashCode());
            Gbp $gbp = this.getGbp();
            result = result * 59 + ($gbp == null ? 43 : ((Object)$gbp).hashCode());
            Gip $gip = this.getGip();
            result = result * 59 + ($gip == null ? 43 : ((Object)$gip).hashCode());
            Hkd $hkd = this.getHkd();
            result = result * 59 + ($hkd == null ? 43 : ((Object)$hkd).hashCode());
            Huf $huf = this.getHuf();
            result = result * 59 + ($huf == null ? 43 : ((Object)$huf).hashCode());
            Jpy $jpy = this.getJpy();
            result = result * 59 + ($jpy == null ? 43 : ((Object)$jpy).hashCode());
            Mxn $mxn = this.getMxn();
            result = result * 59 + ($mxn == null ? 43 : ((Object)$mxn).hashCode());
            Myr $myr = this.getMyr();
            result = result * 59 + ($myr == null ? 43 : ((Object)$myr).hashCode());
            Nok $nok = this.getNok();
            result = result * 59 + ($nok == null ? 43 : ((Object)$nok).hashCode());
            Nzd $nzd = this.getNzd();
            result = result * 59 + ($nzd == null ? 43 : ((Object)$nzd).hashCode());
            Pln $pln = this.getPln();
            result = result * 59 + ($pln == null ? 43 : ((Object)$pln).hashCode());
            Ron $ron = this.getRon();
            result = result * 59 + ($ron == null ? 43 : ((Object)$ron).hashCode());
            Sek $sek = this.getSek();
            result = result * 59 + ($sek == null ? 43 : ((Object)$sek).hashCode());
            Sgd $sgd = this.getSgd();
            result = result * 59 + ($sgd == null ? 43 : ((Object)$sgd).hashCode());
            Usd $usd = this.getUsd();
            result = result * 59 + ($usd == null ? 43 : ((Object)$usd).hashCode());
            return result;
        }

        public static class Aed
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Aed)) {
                    return false;
                }
                Aed other = (Aed)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Aed;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Aud
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Aud)) {
                    return false;
                }
                Aud other = (Aud)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Aud;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Bgn
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bgn)) {
                    return false;
                }
                Bgn other = (Bgn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bgn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Cad
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cad)) {
                    return false;
                }
                Cad other = (Cad)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cad;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Chf
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Chf)) {
                    return false;
                }
                Chf other = (Chf)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Chf;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Czk
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Czk)) {
                    return false;
                }
                Czk other = (Czk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Czk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Dkk
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dkk)) {
                    return false;
                }
                Dkk other = (Dkk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dkk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Eur
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eur)) {
                    return false;
                }
                Eur other = (Eur)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eur;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Gbp
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gbp)) {
                    return false;
                }
                Gbp other = (Gbp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gbp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Gip
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gip)) {
                    return false;
                }
                Gip other = (Gip)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gip;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Hkd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hkd)) {
                    return false;
                }
                Hkd other = (Hkd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hkd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Huf
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Huf)) {
                    return false;
                }
                Huf other = (Huf)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Huf;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Jpy
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jpy)) {
                    return false;
                }
                Jpy other = (Jpy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Jpy;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Mxn
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mxn)) {
                    return false;
                }
                Mxn other = (Mxn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mxn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Myr
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Myr)) {
                    return false;
                }
                Myr other = (Myr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Myr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Nok
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nok)) {
                    return false;
                }
                Nok other = (Nok)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nok;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Nzd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nzd)) {
                    return false;
                }
                Nzd other = (Nzd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nzd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Pln
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pln)) {
                    return false;
                }
                Pln other = (Pln)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pln;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Ron
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ron)) {
                    return false;
                }
                Ron other = (Ron)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ron;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Sek
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sek)) {
                    return false;
                }
                Sek other = (Sek)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sek;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Sgd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sgd)) {
                    return false;
                }
                Sgd other = (Sgd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sgd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Usd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Usd)) {
                    return false;
                }
                Usd other = (Usd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Usd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }
    }

    public static class VerifoneP400
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifoneP400)) {
                return false;
            }
            VerifoneP400 other = (VerifoneP400)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerifoneP400;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }

    public static class Wifi
    extends StripeObject {
        @SerializedName(value="enterprise_eap_peap")
        EnterpriseEapPeap enterpriseEapPeap;
        @SerializedName(value="enterprise_eap_tls")
        EnterpriseEapTls enterpriseEapTls;
        @SerializedName(value="personal_psk")
        PersonalPsk personalPsk;
        @SerializedName(value="type")
        String type;

        @Generated
        public EnterpriseEapPeap getEnterpriseEapPeap() {
            return this.enterpriseEapPeap;
        }

        @Generated
        public EnterpriseEapTls getEnterpriseEapTls() {
            return this.enterpriseEapTls;
        }

        @Generated
        public PersonalPsk getPersonalPsk() {
            return this.personalPsk;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setEnterpriseEapPeap(EnterpriseEapPeap enterpriseEapPeap) {
            this.enterpriseEapPeap = enterpriseEapPeap;
        }

        @Generated
        public void setEnterpriseEapTls(EnterpriseEapTls enterpriseEapTls) {
            this.enterpriseEapTls = enterpriseEapTls;
        }

        @Generated
        public void setPersonalPsk(PersonalPsk personalPsk) {
            this.personalPsk = personalPsk;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wifi)) {
                return false;
            }
            Wifi other = (Wifi)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnterpriseEapPeap this$enterpriseEapPeap = this.getEnterpriseEapPeap();
            EnterpriseEapPeap other$enterpriseEapPeap = other.getEnterpriseEapPeap();
            if (this$enterpriseEapPeap == null ? other$enterpriseEapPeap != null : !((Object)this$enterpriseEapPeap).equals(other$enterpriseEapPeap)) {
                return false;
            }
            EnterpriseEapTls this$enterpriseEapTls = this.getEnterpriseEapTls();
            EnterpriseEapTls other$enterpriseEapTls = other.getEnterpriseEapTls();
            if (this$enterpriseEapTls == null ? other$enterpriseEapTls != null : !((Object)this$enterpriseEapTls).equals(other$enterpriseEapTls)) {
                return false;
            }
            PersonalPsk this$personalPsk = this.getPersonalPsk();
            PersonalPsk other$personalPsk = other.getPersonalPsk();
            if (this$personalPsk == null ? other$personalPsk != null : !((Object)this$personalPsk).equals(other$personalPsk)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Wifi;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EnterpriseEapPeap $enterpriseEapPeap = this.getEnterpriseEapPeap();
            result = result * 59 + ($enterpriseEapPeap == null ? 43 : ((Object)$enterpriseEapPeap).hashCode());
            EnterpriseEapTls $enterpriseEapTls = this.getEnterpriseEapTls();
            result = result * 59 + ($enterpriseEapTls == null ? 43 : ((Object)$enterpriseEapTls).hashCode());
            PersonalPsk $personalPsk = this.getPersonalPsk();
            result = result * 59 + ($personalPsk == null ? 43 : ((Object)$personalPsk).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class EnterpriseEapPeap
        extends StripeObject {
            @SerializedName(value="ca_certificate_file")
            String caCertificateFile;
            @SerializedName(value="password")
            String password;
            @SerializedName(value="ssid")
            String ssid;
            @SerializedName(value="username")
            String username;

            @Generated
            public String getCaCertificateFile() {
                return this.caCertificateFile;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public String getSsid() {
                return this.ssid;
            }

            @Generated
            public String getUsername() {
                return this.username;
            }

            @Generated
            public void setCaCertificateFile(String caCertificateFile) {
                this.caCertificateFile = caCertificateFile;
            }

            @Generated
            public void setPassword(String password) {
                this.password = password;
            }

            @Generated
            public void setSsid(String ssid) {
                this.ssid = ssid;
            }

            @Generated
            public void setUsername(String username) {
                this.username = username;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EnterpriseEapPeap)) {
                    return false;
                }
                EnterpriseEapPeap other = (EnterpriseEapPeap)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$caCertificateFile = this.getCaCertificateFile();
                String other$caCertificateFile = other.getCaCertificateFile();
                if (this$caCertificateFile == null ? other$caCertificateFile != null : !this$caCertificateFile.equals(other$caCertificateFile)) {
                    return false;
                }
                String this$password = this.getPassword();
                String other$password = other.getPassword();
                if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                    return false;
                }
                String this$ssid = this.getSsid();
                String other$ssid = other.getSsid();
                if (this$ssid == null ? other$ssid != null : !this$ssid.equals(other$ssid)) {
                    return false;
                }
                String this$username = this.getUsername();
                String other$username = other.getUsername();
                return !(this$username == null ? other$username != null : !this$username.equals(other$username));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EnterpriseEapPeap;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $caCertificateFile = this.getCaCertificateFile();
                result = result * 59 + ($caCertificateFile == null ? 43 : $caCertificateFile.hashCode());
                String $password = this.getPassword();
                result = result * 59 + ($password == null ? 43 : $password.hashCode());
                String $ssid = this.getSsid();
                result = result * 59 + ($ssid == null ? 43 : $ssid.hashCode());
                String $username = this.getUsername();
                result = result * 59 + ($username == null ? 43 : $username.hashCode());
                return result;
            }
        }

        public static class EnterpriseEapTls
        extends StripeObject {
            @SerializedName(value="ca_certificate_file")
            String caCertificateFile;
            @SerializedName(value="client_certificate_file")
            String clientCertificateFile;
            @SerializedName(value="private_key_file")
            String privateKeyFile;
            @SerializedName(value="private_key_file_password")
            String privateKeyFilePassword;
            @SerializedName(value="ssid")
            String ssid;

            @Generated
            public String getCaCertificateFile() {
                return this.caCertificateFile;
            }

            @Generated
            public String getClientCertificateFile() {
                return this.clientCertificateFile;
            }

            @Generated
            public String getPrivateKeyFile() {
                return this.privateKeyFile;
            }

            @Generated
            public String getPrivateKeyFilePassword() {
                return this.privateKeyFilePassword;
            }

            @Generated
            public String getSsid() {
                return this.ssid;
            }

            @Generated
            public void setCaCertificateFile(String caCertificateFile) {
                this.caCertificateFile = caCertificateFile;
            }

            @Generated
            public void setClientCertificateFile(String clientCertificateFile) {
                this.clientCertificateFile = clientCertificateFile;
            }

            @Generated
            public void setPrivateKeyFile(String privateKeyFile) {
                this.privateKeyFile = privateKeyFile;
            }

            @Generated
            public void setPrivateKeyFilePassword(String privateKeyFilePassword) {
                this.privateKeyFilePassword = privateKeyFilePassword;
            }

            @Generated
            public void setSsid(String ssid) {
                this.ssid = ssid;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EnterpriseEapTls)) {
                    return false;
                }
                EnterpriseEapTls other = (EnterpriseEapTls)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$caCertificateFile = this.getCaCertificateFile();
                String other$caCertificateFile = other.getCaCertificateFile();
                if (this$caCertificateFile == null ? other$caCertificateFile != null : !this$caCertificateFile.equals(other$caCertificateFile)) {
                    return false;
                }
                String this$clientCertificateFile = this.getClientCertificateFile();
                String other$clientCertificateFile = other.getClientCertificateFile();
                if (this$clientCertificateFile == null ? other$clientCertificateFile != null : !this$clientCertificateFile.equals(other$clientCertificateFile)) {
                    return false;
                }
                String this$privateKeyFile = this.getPrivateKeyFile();
                String other$privateKeyFile = other.getPrivateKeyFile();
                if (this$privateKeyFile == null ? other$privateKeyFile != null : !this$privateKeyFile.equals(other$privateKeyFile)) {
                    return false;
                }
                String this$privateKeyFilePassword = this.getPrivateKeyFilePassword();
                String other$privateKeyFilePassword = other.getPrivateKeyFilePassword();
                if (this$privateKeyFilePassword == null ? other$privateKeyFilePassword != null : !this$privateKeyFilePassword.equals(other$privateKeyFilePassword)) {
                    return false;
                }
                String this$ssid = this.getSsid();
                String other$ssid = other.getSsid();
                return !(this$ssid == null ? other$ssid != null : !this$ssid.equals(other$ssid));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EnterpriseEapTls;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $caCertificateFile = this.getCaCertificateFile();
                result = result * 59 + ($caCertificateFile == null ? 43 : $caCertificateFile.hashCode());
                String $clientCertificateFile = this.getClientCertificateFile();
                result = result * 59 + ($clientCertificateFile == null ? 43 : $clientCertificateFile.hashCode());
                String $privateKeyFile = this.getPrivateKeyFile();
                result = result * 59 + ($privateKeyFile == null ? 43 : $privateKeyFile.hashCode());
                String $privateKeyFilePassword = this.getPrivateKeyFilePassword();
                result = result * 59 + ($privateKeyFilePassword == null ? 43 : $privateKeyFilePassword.hashCode());
                String $ssid = this.getSsid();
                result = result * 59 + ($ssid == null ? 43 : $ssid.hashCode());
                return result;
            }
        }

        public static class PersonalPsk
        extends StripeObject {
            @SerializedName(value="password")
            String password;
            @SerializedName(value="ssid")
            String ssid;

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public String getSsid() {
                return this.ssid;
            }

            @Generated
            public void setPassword(String password) {
                this.password = password;
            }

            @Generated
            public void setSsid(String ssid) {
                this.ssid = ssid;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PersonalPsk)) {
                    return false;
                }
                PersonalPsk other = (PersonalPsk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$password = this.getPassword();
                String other$password = other.getPassword();
                if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                    return false;
                }
                String this$ssid = this.getSsid();
                String other$ssid = other.getSsid();
                return !(this$ssid == null ? other$ssid != null : !this$ssid.equals(other$ssid));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PersonalPsk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $password = this.getPassword();
                result = result * 59 + ($password == null ? 43 : $password.hashCode());
                String $ssid = this.getSsid();
                result = result * 59 + ($ssid == null ? 43 : $ssid.hashCode());
                return result;
            }
        }
    }
}

