/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.storage.Storage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/core/storage/SharedPreferencesStorage;", "Lcom/stripe/android/core/storage/Storage;", "context", "Landroid/content/Context;", "purpose", "", "(Landroid/content/Context;Ljava/lang/String;)V", "sharedPrefs", "Landroid/content/SharedPreferences;", "getSharedPrefs", "()Landroid/content/SharedPreferences;", "sharedPrefs$delegate", "Lkotlin/Lazy;", "clear", "", "getBoolean", "key", "defaultValue", "getFloat", "", "getInt", "", "getLong", "", "getString", "remove", "storeValue", "value", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String purpose;
    @NotNull
    private final Lazy sharedPrefs$delegate;
    @NotNull
    private static final String logTag;

    public SharedPreferencesStorage(@NotNull Context context, @NotNull String purpose) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        this.context = context;
        this.purpose = purpose;
        this.sharedPrefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SharedPreferencesStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SharedPreferences invoke() {
                return SharedPreferencesStorage.access$getContext$p(this.this$0).getSharedPreferences("stripe_shared_prefs", 0);
            }
        }));
    }

    private final SharedPreferences getSharedPrefs() {
        Lazy lazy = this.sharedPrefs$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @Override
    public boolean storeValue(@NotNull String key, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$storeValue_u24lambda_u241 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u241_u24lambda_u240 = $this$storeValue_u24lambda_u241.edit();
            boolean bl3 = false;
            $this$storeValue_u24lambda_u241_u24lambda_u240.putString(this.purpose + "_" + key, value);
            bl = $this$storeValue_u24lambda_u241_u24lambda_u240.commit();
        } else {
            boolean bl4;
            boolean $this$storeValue_u24lambda_u242 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl4;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, long value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$storeValue_u24lambda_u244 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u244_u24lambda_u243 = $this$storeValue_u24lambda_u244.edit();
            boolean bl3 = false;
            $this$storeValue_u24lambda_u244_u24lambda_u243.putLong(this.purpose + "_" + key, value);
            bl = $this$storeValue_u24lambda_u244_u24lambda_u243.commit();
        } else {
            boolean bl4;
            boolean $this$storeValue_u24lambda_u245 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl4;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, int value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$storeValue_u24lambda_u247 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u247_u24lambda_u246 = $this$storeValue_u24lambda_u247.edit();
            boolean bl3 = false;
            $this$storeValue_u24lambda_u247_u24lambda_u246.putInt(this.purpose + "_" + key, value);
            bl = $this$storeValue_u24lambda_u247_u24lambda_u246.commit();
        } else {
            boolean bl4;
            boolean $this$storeValue_u24lambda_u248 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl4;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, float value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$storeValue_u24lambda_u2410 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2410_u24lambda_u249 = $this$storeValue_u24lambda_u2410.edit();
            boolean bl3 = false;
            $this$storeValue_u24lambda_u2410_u24lambda_u249.putFloat(this.purpose + "_" + key, value);
            bl = $this$storeValue_u24lambda_u2410_u24lambda_u249.commit();
        } else {
            boolean bl4;
            boolean $this$storeValue_u24lambda_u2411 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl4;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, boolean value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$storeValue_u24lambda_u2413 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2413_u24lambda_u2412 = $this$storeValue_u24lambda_u2413.edit();
            boolean bl3 = false;
            $this$storeValue_u24lambda_u2413_u24lambda_u2412.putBoolean(this.purpose + "_" + key, value);
            bl = $this$storeValue_u24lambda_u2413_u24lambda_u2412.commit();
        } else {
            boolean bl4;
            boolean $this$storeValue_u24lambda_u2414 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl4;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getString(@NotNull String key, @NotNull String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            Object object = this.getSharedPrefs();
            if (object == null || (object = object.getString(this.purpose + "_" + key, defaultValue)) == null) {
                String string2;
                String $this$getString_u24lambda_u2415 = string2 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)("Unable to retrieve a String for " + key));
                object = string2;
            }
            string = object;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)(key + " is not a String"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)("Error retrieving String for " + key), (Throwable)t);
            }
            string = defaultValue;
        }
        return string;
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            long l2;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            if (sharedPreferences != null) {
                l2 = sharedPreferences.getLong(this.purpose + "_" + key, defaultValue);
            } else {
                long l3;
                long $this$getLong_u24lambda_u2416 = l3 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)("Unable to retrieve a Long for " + key));
                l2 = l3;
            }
            l = l2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)(key + " is not a Long"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)("Error retrieving Long for " + key), (Throwable)t);
            }
            l = defaultValue;
        }
        return l;
    }

    @Override
    public int getInt(@NotNull String key, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            int n2;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            if (sharedPreferences != null) {
                n2 = sharedPreferences.getInt(this.purpose + "_" + key, defaultValue);
            } else {
                int n3;
                int $this$getInt_u24lambda_u2417 = n3 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)("Unable to retrieve an Int for " + key));
                n2 = n3;
            }
            n = n2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)(key + " is not a Int"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)("Error retrieving Int for " + key), (Throwable)t);
            }
            n = defaultValue;
        }
        return n;
    }

    @Override
    public float getFloat(@NotNull String key, float defaultValue) {
        float f;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            float f2;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            if (sharedPreferences != null) {
                f2 = sharedPreferences.getFloat(this.purpose + "_" + key, defaultValue);
            } else {
                float f3;
                float $this$getFloat_u24lambda_u2418 = f3 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)("Unable to retrieve a Float for " + key));
                f2 = f3;
            }
            f = f2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)(key + " is not a Float"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)("Error retrieving Float for " + key), (Throwable)t);
            }
            f = defaultValue;
        }
        return f;
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            boolean bl2;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            if (sharedPreferences != null) {
                bl2 = sharedPreferences.getBoolean(this.purpose + "_" + key, defaultValue);
            } else {
                boolean bl3;
                boolean $this$getBoolean_u24lambda_u2419 = bl3 = defaultValue;
                boolean bl4 = false;
                Log.e((String)logTag, (String)("Unable to retrieve a Boolean for " + key));
                bl2 = bl3;
            }
            bl = bl2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)(key + " is not a Boolean"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)("Error retrieving Boolean for " + key), (Throwable)t);
            }
            bl = defaultValue;
        }
        return bl;
    }

    @Override
    public boolean remove(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$remove_u24lambda_u2421 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$remove_u24lambda_u2421_u24lambda_u2420 = $this$remove_u24lambda_u2421.edit();
            boolean bl3 = false;
            $this$remove_u24lambda_u2421_u24lambda_u2420.remove(key);
            bl = $this$remove_u24lambda_u2421_u24lambda_u2420.commit();
        } else {
            boolean bl4;
            boolean $this$remove_u24lambda_u2422 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)"Shared preferences is unavailable to remove values");
            bl = bl4;
        }
        return bl;
    }

    @Override
    public boolean clear() {
        boolean bl;
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences != null) {
            SharedPreferences $this$clear_u24lambda_u2424 = sharedPreferences;
            boolean bl2 = false;
            SharedPreferences.Editor $this$clear_u24lambda_u2424_u24lambda_u2423 = $this$clear_u24lambda_u2424.edit();
            boolean bl3 = false;
            $this$clear_u24lambda_u2424_u24lambda_u2423.clear();
            bl = $this$clear_u24lambda_u2424_u24lambda_u2423.commit();
        } else {
            boolean bl4;
            boolean $this$clear_u24lambda_u2425 = bl4 = false;
            boolean bl5 = false;
            Log.e((String)logTag, (String)"Shared preferences is unavailable to clear values");
            bl = bl4;
        }
        return bl;
    }

    public static final /* synthetic */ Context access$getContext$p(SharedPreferencesStorage $this) {
        return $this.context;
    }

    static {
        String string = SharedPreferencesStorage.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        logTag = string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/core/storage/SharedPreferencesStorage$Companion;", "", "()V", "logTag", "", "stripe-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

