/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.model;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryCodeKt;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/core/model/CountryUtils;", "", "()V", "CARD_POSTAL_CODE_COUNTRIES", "", "", "cachedCountriesLocale", "Ljava/util/Locale;", "cachedOrderedLocalizedCountries", "", "Lcom/stripe/android/core/model/Country;", "supportedBillingCountries", "getSupportedBillingCountries", "()Ljava/util/Set;", "doesCountryUsePostalCode", "", "countryCode", "Lcom/stripe/android/core/model/CountryCode;", "formatNameForSorting", "name", "formatNameForSorting$stripe_core_release", "getCountryByCode", "currentLocale", "getCountryCodeByName", "countryName", "getDisplayCountry", "getOrderedCountries", "getSortedLocalizedCountries", "localizedCountries", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCountryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryUtils.kt\ncom/stripe/android/core/model/CountryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n288#2,2:135\n288#2,2:137\n288#2,2:139\n819#2:141\n847#2,2:142\n1045#2:144\n*S KotlinDebug\n*F\n+ 1 CountryUtils.kt\ncom/stripe/android/core/model/CountryUtils\n*L\n39#1:131\n39#1:132,3\n54#1:135,2\n59#1:137,2\n117#1:139,2\n122#1:141\n122#1:142,2\n123#1:144\n*E\n"})
public final class CountryUtils {
    @NotNull
    public static final CountryUtils INSTANCE = new CountryUtils();
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static final Set<String> supportedBillingCountries;
    @NotNull
    private static final Set<String> CARD_POSTAL_CODE_COUNTRIES;
    @Nullable
    private static volatile Locale cachedCountriesLocale;
    @NotNull
    private static volatile List<Country> cachedOrderedLocalizedCountries;

    private CountryUtils() {
    }

    @NotNull
    public final Set<String> getSupportedBillingCountries() {
        return supportedBillingCountries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> localizedCountries(Locale currentLocale) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = supportedBillingCountries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void code;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CountryCode countryCode = CountryCode.Companion.create((String)code);
            String string2 = new Locale("", (String)code).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayCountry(...)");
            collection.add(new Country(countryCode, string2));
        }
        return (List)destination$iv$iv;
    }

    public final /* synthetic */ String getDisplayCountry(CountryCode countryCode, Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Object object = this.getCountryByCode(countryCode, currentLocale);
        if (object == null || (object = ((Country)object).getName()) == null) {
            String string = new Locale("", countryCode.getValue()).getDisplayCountry(currentLocale);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayCountry(...)");
        }
        return object;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ CountryCode getCountryCodeByName(String countryName, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)countryName, (String)"countryName");
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.getSortedLocalizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)countryName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country != null ? country.getCode() : null;
    }

    public final /* synthetic */ Country getCountryByCode(CountryCode countryCode, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.getSortedLocalizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)countryCode)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ List getOrderedCountries(Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        return this.getSortedLocalizedCountries(currentLocale);
    }

    @VisibleForTesting
    @NotNull
    public final String formatNameForSorting$stripe_core_release(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("\\p{Mn}+");
        String string3 = "";
        charSequence = regex.replace(charSequence, string3);
        regex = new Regex("[^A-Za-z ]");
        string3 = "";
        charSequence = regex.replace(charSequence, string3);
        regex = new Regex("[^\\p{ASCII}]");
        string3 = "";
        return regex.replace(charSequence, string3);
    }

    @Deprecated(message="Use with parameter CountryCode", replaceWith=@ReplaceWith(expression="CountryUtils.doesCountryUsePostalCode(CountryCode.create(countryCode))", imports={"com.stripe.android.model.CountryCode"}))
    public final /* synthetic */ boolean doesCountryUsePostalCode(String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string = countryCode.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return CARD_POSTAL_CODE_COUNTRIES.contains(string);
    }

    public final /* synthetic */ boolean doesCountryUsePostalCode(CountryCode countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return CARD_POSTAL_CODE_COUNTRIES.contains(countryCode.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> getSortedLocalizedCountries(Locale currentLocale) {
        List<Country> list;
        if (Intrinsics.areEqual((Object)currentLocale, (Object)cachedCountriesLocale)) {
            list = cachedOrderedLocalizedCountries;
        } else {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object v1;
            Iterable $this$firstOrNull$iv;
            List<Country> localizedCountries;
            block4: {
                cachedCountriesLocale = currentLocale;
                localizedCountries = this.localizedCountries(currentLocale);
                $this$firstOrNull$iv = localizedCountries;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Country it = (Country)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            $this$firstOrNull$iv = localizedCountries;
            Collection collection = CollectionsKt.listOfNotNull(v1);
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Country it = (Country)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            cachedOrderedLocalizedCountries = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Country it = (Country)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)CountryUtils.INSTANCE.formatNameForSorting$stripe_core_release(it.getName()));
                    it = (Country)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)CountryUtils.INSTANCE.formatNameForSorting$stripe_core_release(it.getName()))));
                }
            }));
            list = cachedOrderedLocalizedCountries;
        }
        return list;
    }

    static {
        Object[] objectArray = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CV", "CW", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MK", "ML", "MM", "MN", "MO", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SZ", "TA", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VN", "VU", "WF", "WS", "XK", "YE", "YT", "ZA", "ZM", "ZW"};
        supportedBillingCountries = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"US", "GB", "CA"};
        CARD_POSTAL_CODE_COUNTRIES = SetsKt.setOf((Object[])objectArray);
        cachedOrderedLocalizedCountries = CollectionsKt.emptyList();
    }
}

