/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceCardData
extends StripeSourceTypeModel {
    public static final String REQUIRED = "required";
    public static final String OPTIONAL = "optional";
    public static final String NOT_SUPPORTED = "not_supported";
    public static final String RECOMMENDED = "recommended";
    public static final String UNKNOWN = "unknown";
    private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    private static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    private static final String FIELD_BRAND = "brand";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CVC_CHECK = "cvc_check";
    private static final String FIELD_DYNAMIC_LAST4 = "dynamic_last4";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_FUNDING = "funding";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_THREE_D_SECURE = "three_d_secure";
    private static final String FIELD_TOKENIZATION_METHOD = "tokenization_method";
    private static final Set<String> STANDARD_FIELDS = new HashSet<String>(Arrays.asList("address_line1_check", "address_zip_check", "brand", "country", "cvc_check", "dynamic_last4", "exp_month", "exp_year", "funding", "last4", "three_d_secure", "tokenization_method"));
    @Nullable
    private final String mAddressLine1Check;
    @Nullable
    private final String mAddressZipCheck;
    @Nullable
    private final String mBrand;
    @Nullable
    private final String mCountry;
    @Nullable
    private final String mCvcCheck;
    @Nullable
    private final String mDynamicLast4;
    @Nullable
    private final Integer mExpiryMonth;
    @Nullable
    private final Integer mExpiryYear;
    @Nullable
    private final String mFunding;
    @Nullable
    private final String mLast4;
    @Nullable
    private final String mThreeDSecureStatus;
    @Nullable
    private final String mTokenizationMethod;

    private SourceCardData(@NonNull Builder builder) {
        super(builder);
        this.mAddressLine1Check = builder.mAddressLine1Check;
        this.mAddressZipCheck = builder.mAddressZipCheck;
        this.mBrand = builder.mBrand;
        this.mCountry = builder.mCountry;
        this.mCvcCheck = builder.mCvcCheck;
        this.mDynamicLast4 = builder.mDynamicLast4;
        this.mExpiryMonth = builder.mExpiryMonth;
        this.mExpiryYear = builder.mExpiryYear;
        this.mFunding = builder.mFunding;
        this.mLast4 = builder.mLast4;
        this.mThreeDSecureStatus = builder.mThreeDSecureStatus;
        this.mTokenizationMethod = builder.mTokenizationMethod;
    }

    @Nullable
    public String getAddressLine1Check() {
        return this.mAddressLine1Check;
    }

    @Nullable
    public String getAddressZipCheck() {
        return this.mAddressZipCheck;
    }

    @Nullable
    public String getBrand() {
        return this.mBrand;
    }

    @Nullable
    public String getCountry() {
        return this.mCountry;
    }

    @Nullable
    public String getCvcCheck() {
        return this.mCvcCheck;
    }

    @Nullable
    public String getDynamicLast4() {
        return this.mDynamicLast4;
    }

    @Nullable
    public Integer getExpiryMonth() {
        return this.mExpiryMonth;
    }

    @Nullable
    public Integer getExpiryYear() {
        return this.mExpiryYear;
    }

    @Nullable
    public String getFunding() {
        return this.mFunding;
    }

    @Nullable
    public String getLast4() {
        return this.mLast4;
    }

    @Nullable
    public String getThreeDSecureStatus() {
        return this.mThreeDSecureStatus;
    }

    @Nullable
    public String getTokenizationMethod() {
        return this.mTokenizationMethod;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(super.toMap());
        ((AbstractMap)map).put(FIELD_ADDRESS_LINE1_CHECK, this.mAddressLine1Check);
        ((AbstractMap)map).put(FIELD_ADDRESS_ZIP_CHECK, this.mAddressZipCheck);
        ((AbstractMap)map).put(FIELD_BRAND, this.mBrand);
        ((AbstractMap)map).put(FIELD_COUNTRY, this.mCountry);
        ((AbstractMap)map).put(FIELD_DYNAMIC_LAST4, this.mDynamicLast4);
        ((AbstractMap)map).put(FIELD_EXP_MONTH, this.mExpiryMonth);
        ((AbstractMap)map).put(FIELD_EXP_YEAR, this.mExpiryYear);
        ((AbstractMap)map).put(FIELD_FUNDING, this.mFunding);
        ((AbstractMap)map).put(FIELD_LAST4, this.mLast4);
        ((AbstractMap)map).put(FIELD_THREE_D_SECURE, this.mThreeDSecureStatus);
        ((AbstractMap)map).put(FIELD_TOKENIZATION_METHOD, this.mTokenizationMethod);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Nullable
    static SourceCardData fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Builder cardData = new Builder().setAddressLine1Check(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1_CHECK)).setAddressZipCheck(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP_CHECK)).setBrand(Card.asCardBrand(StripeJsonUtils.optString(jsonObject, FIELD_BRAND))).setCountry(StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY)).setCvcCheck(StripeJsonUtils.optString(jsonObject, FIELD_CVC_CHECK)).setDynamicLast4(StripeJsonUtils.optString(jsonObject, FIELD_DYNAMIC_LAST4)).setExpiryMonth(StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_MONTH)).setExpiryYear(StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_YEAR)).setFunding(Card.asFundingType(StripeJsonUtils.optString(jsonObject, FIELD_FUNDING))).setLast4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4)).setThreeDSecureStatus(SourceCardData.asThreeDSecureStatus(StripeJsonUtils.optString(jsonObject, FIELD_THREE_D_SECURE))).setTokenizationMethod(StripeJsonUtils.optString(jsonObject, FIELD_TOKENIZATION_METHOD));
        Map<String, Object> nonStandardFields = SourceCardData.jsonObjectToMapWithoutKeys(jsonObject, STANDARD_FIELDS);
        if (nonStandardFields != null) {
            cardData.setAdditionalFields(nonStandardFields);
        }
        return cardData.build();
    }

    @VisibleForTesting
    static SourceCardData fromString(String jsonString) {
        try {
            return SourceCardData.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException badJson) {
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    static String asThreeDSecureStatus(@Nullable String threeDSecureStatus) {
        if (StripeJsonUtils.nullIfNullOrEmpty(threeDSecureStatus) == null) {
            return null;
        }
        if (REQUIRED.equalsIgnoreCase(threeDSecureStatus)) {
            return REQUIRED;
        }
        if (OPTIONAL.equalsIgnoreCase(threeDSecureStatus)) {
            return OPTIONAL;
        }
        if (NOT_SUPPORTED.equalsIgnoreCase(threeDSecureStatus)) {
            return NOT_SUPPORTED;
        }
        if (RECOMMENDED.equalsIgnoreCase(threeDSecureStatus)) {
            return RECOMMENDED;
        }
        return UNKNOWN;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SourceCardData && this.typedEquals((SourceCardData)obj);
    }

    boolean typedEquals(@NonNull SourceCardData sourceCardData) {
        return super.typedEquals(sourceCardData) && ObjectUtils.equals(this.mAddressLine1Check, sourceCardData.mAddressLine1Check) && ObjectUtils.equals(this.mAddressZipCheck, sourceCardData.mAddressZipCheck) && ObjectUtils.equals(this.mBrand, sourceCardData.mBrand) && ObjectUtils.equals(this.mCountry, sourceCardData.mCountry) && ObjectUtils.equals(this.mCvcCheck, sourceCardData.mCvcCheck) && ObjectUtils.equals(this.mDynamicLast4, sourceCardData.mDynamicLast4) && ObjectUtils.equals(this.mExpiryMonth, sourceCardData.mExpiryMonth) && ObjectUtils.equals(this.mExpiryYear, sourceCardData.mExpiryYear) && ObjectUtils.equals(this.mFunding, sourceCardData.mFunding) && ObjectUtils.equals(this.mLast4, sourceCardData.mLast4) && ObjectUtils.equals(this.mThreeDSecureStatus, sourceCardData.mThreeDSecureStatus) && ObjectUtils.equals(this.mTokenizationMethod, sourceCardData.mTokenizationMethod);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.mAddressLine1Check, this.mAddressZipCheck, this.mBrand, this.mCountry, this.mCvcCheck, this.mDynamicLast4, this.mExpiryMonth, this.mExpiryYear, this.mFunding, this.mLast4, this.mThreeDSecureStatus, this.mTokenizationMethod);
    }

    private static final class Builder
    extends StripeSourceTypeModel.BaseBuilder {
        private String mAddressLine1Check;
        private String mAddressZipCheck;
        private String mBrand;
        private String mCountry;
        private String mCvcCheck;
        private String mDynamicLast4;
        private Integer mExpiryMonth;
        private Integer mExpiryYear;
        private String mFunding;
        private String mLast4;
        private String mThreeDSecureStatus;
        private String mTokenizationMethod;

        private Builder() {
        }

        @NonNull
        private Builder setAddressLine1Check(String addressLine1Check) {
            this.mAddressLine1Check = addressLine1Check;
            return this;
        }

        @NonNull
        private Builder setAddressZipCheck(String addressZipCheck) {
            this.mAddressZipCheck = addressZipCheck;
            return this;
        }

        @NonNull
        private Builder setBrand(String brand) {
            this.mBrand = brand;
            return this;
        }

        @NonNull
        private Builder setCountry(String country) {
            this.mCountry = country;
            return this;
        }

        @NonNull
        private Builder setCvcCheck(String cvcCheck) {
            this.mCvcCheck = cvcCheck;
            return this;
        }

        @NonNull
        private Builder setDynamicLast4(String dynamicLast4) {
            this.mDynamicLast4 = dynamicLast4;
            return this;
        }

        @NonNull
        private Builder setExpiryMonth(Integer expiryMonth) {
            this.mExpiryMonth = expiryMonth;
            return this;
        }

        @NonNull
        private Builder setExpiryYear(Integer expiryYear) {
            this.mExpiryYear = expiryYear;
            return this;
        }

        @NonNull
        private Builder setFunding(String funding) {
            this.mFunding = funding;
            return this;
        }

        @NonNull
        private Builder setLast4(String last4) {
            this.mLast4 = last4;
            return this;
        }

        @NonNull
        private Builder setThreeDSecureStatus(String threeDSecureStatus) {
            this.mThreeDSecureStatus = threeDSecureStatus;
            return this;
        }

        @NonNull
        private Builder setTokenizationMethod(String tokenizationMethod) {
            this.mTokenizationMethod = tokenizationMethod;
            return this;
        }

        @NonNull
        public SourceCardData build() {
            return new SourceCardData(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThreeDSecureStatus {
    }
}

