/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentIntent
extends StripeModel
implements StripeIntent {
    private static final String VALUE_PAYMENT_INTENT = "payment_intent";
    static final String FIELD_ID = "id";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_AMOUNT = "amount";
    static final String FIELD_CREATED = "created";
    static final String FIELD_CANCELED = "canceled_at";
    static final String FIELD_CAPTURE_METHOD = "capture_method";
    static final String FIELD_CLIENT_SECRET = "client_secret";
    static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    static final String FIELD_CURRENCY = "currency";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_NEXT_ACTION = "next_action";
    static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    static final String FIELD_SOURCE = "source";
    static final String FIELD_STATUS = "status";
    static final String FIELD_SETUP_FUTURE_USAGE = "setup_future_usage";
    private static final String FIELD_NEXT_ACTION_TYPE = "type";
    @Nullable
    private final String mId;
    @Nullable
    private final String mObjectType;
    @NonNull
    private final List<String> mPaymentMethodTypes;
    @Nullable
    private final Long mAmount;
    @Nullable
    private final Long mCanceledAt;
    @Nullable
    private final String mCaptureMethod;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final String mConfirmationMethod;
    @Nullable
    private final Long mCreated;
    @Nullable
    private final String mCurrency;
    @Nullable
    private final String mDescription;
    @Nullable
    private final Boolean mLiveMode;
    @Nullable
    private final Map<String, Object> mNextAction;
    @Nullable
    private final StripeIntent.NextActionType mNextActionType;
    @Nullable
    private final String mReceiptEmail;
    @Nullable
    private final String mSource;
    @Nullable
    private final StripeIntent.Status mStatus;
    @Nullable
    private final StripeIntent.Usage mSetupFutureUsage;

    @Nullable
    public String getId() {
        return this.mId;
    }

    @NonNull
    public List<String> getPaymentMethodTypes() {
        return this.mPaymentMethodTypes;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public Long getCanceledAt() {
        return this.mCanceledAt;
    }

    @Nullable
    public String getCaptureMethod() {
        return this.mCaptureMethod;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public String getConfirmationMethod() {
        return this.mConfirmationMethod;
    }

    @Nullable
    public Long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    @Override
    public boolean requiresAction() {
        return this.mStatus == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.mStatus == StripeIntent.Status.RequiresConfirmation;
    }

    @Nullable
    public Map<String, Object> getNextAction() {
        return this.mNextAction;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        return this.mNextActionType;
    }

    @Nullable
    public Uri getRedirectUrl() {
        StripeIntent.RedirectData redirectData = this.getRedirectData();
        if (redirectData == null) {
            return null;
        }
        return redirectData.url;
    }

    @Override
    @Nullable
    public StripeIntent.SdkData getStripeSdkData() {
        if (this.mNextAction == null || StripeIntent.NextActionType.UseStripeSdk != this.mNextActionType) {
            return null;
        }
        return new StripeIntent.SdkData((Map)this.mNextAction.get(StripeIntent.NextActionType.UseStripeSdk.code));
    }

    @Override
    @Nullable
    public StripeIntent.RedirectData getRedirectData() {
        Object redirectToUrl;
        if (StripeIntent.NextActionType.RedirectToUrl != this.mNextActionType) {
            return null;
        }
        Map<String, Object> nextAction = StripeIntent.Status.RequiresAction == this.mStatus ? this.mNextAction : null;
        if (nextAction == null) {
            return null;
        }
        StripeIntent.NextActionType nextActionType = StripeIntent.NextActionType.fromCode((String)nextAction.get(FIELD_NEXT_ACTION_TYPE));
        if (StripeIntent.NextActionType.RedirectToUrl == nextActionType && (redirectToUrl = nextAction.get(nextActionType.code)) instanceof Map) {
            return StripeIntent.RedirectData.create((Map)redirectToUrl);
        }
        return null;
    }

    @Nullable
    public String getReceiptEmail() {
        return this.mReceiptEmail;
    }

    @Nullable
    public String getSource() {
        return this.mSource;
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.mStatus;
    }

    private PaymentIntent(@Nullable String id2, @Nullable String objectType, @NonNull List<String> paymentMethodTypes, @Nullable Long amount, @Nullable Long canceledAt, @Nullable String captureMethod, @Nullable String clientSecret, @Nullable String confirmationMethod, @Nullable Long created, @Nullable String currency, @Nullable String description, @Nullable Boolean liveMode, @Nullable Map<String, Object> nextAction, @Nullable String receiptEmail, @Nullable String source, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage) {
        this.mId = id2;
        this.mObjectType = objectType;
        this.mPaymentMethodTypes = paymentMethodTypes;
        this.mAmount = amount;
        this.mCanceledAt = canceledAt;
        this.mCaptureMethod = captureMethod;
        this.mClientSecret = clientSecret;
        this.mConfirmationMethod = confirmationMethod;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mDescription = description;
        this.mLiveMode = liveMode;
        this.mNextAction = nextAction;
        this.mReceiptEmail = receiptEmail;
        this.mSource = source;
        this.mStatus = status;
        this.mSetupFutureUsage = setupFutureUsage;
        this.mNextActionType = this.mNextAction != null ? StripeIntent.NextActionType.fromCode((String)this.mNextAction.get(FIELD_NEXT_ACTION_TYPE)) : null;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Nullable
    public static PaymentIntent fromString(@Nullable String jsonString) {
        try {
            return PaymentIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_PAYMENT_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        String id2 = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        List<String> paymentMethodTypes = PaymentIntent.jsonArrayToList(jsonObject.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        Long canceledAt = StripeJsonUtils.optLong(jsonObject, FIELD_CANCELED);
        String captureMethod = StripeJsonUtils.optString(jsonObject, FIELD_CAPTURE_METHOD);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        String confirmationMethod = StripeJsonUtils.optString(jsonObject, FIELD_CONFIRMATION_METHOD);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY);
        String description = StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION);
        Boolean livemode = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String receiptEmail = StripeJsonUtils.optString(jsonObject, FIELD_RECEIPT_EMAIL);
        StripeIntent.Status status = StripeIntent.Status.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        StripeIntent.Usage setupFutureUsage = StripeIntent.Usage.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_SETUP_FUTURE_USAGE));
        Map<String, Object> nextAction = StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_ACTION);
        String source = StripeJsonUtils.optString(jsonObject, FIELD_SOURCE);
        return new PaymentIntent(id2, objectType, paymentMethodTypes, amount, canceledAt, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, nextAction, receiptEmail, source, status, setupFutureUsage);
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_OBJECT, this.mObjectType);
        ((AbstractMap)map).put(FIELD_PAYMENT_METHOD_TYPES, this.mPaymentMethodTypes);
        ((AbstractMap)map).put(FIELD_AMOUNT, this.mAmount);
        ((AbstractMap)map).put(FIELD_CANCELED, this.mCanceledAt);
        ((AbstractMap)map).put(FIELD_CLIENT_SECRET, this.mClientSecret);
        ((AbstractMap)map).put(FIELD_CAPTURE_METHOD, this.mCaptureMethod);
        ((AbstractMap)map).put(FIELD_CONFIRMATION_METHOD, this.mConfirmationMethod);
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_CURRENCY, this.mCurrency);
        ((AbstractMap)map).put(FIELD_DESCRIPTION, this.mDescription);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ((AbstractMap)map).put(FIELD_NEXT_ACTION, this.mNextAction);
        ((AbstractMap)map).put(FIELD_RECEIPT_EMAIL, this.mReceiptEmail);
        ((AbstractMap)map).put(FIELD_STATUS, this.mStatus != null ? this.mStatus.code : null);
        ((AbstractMap)map).put(FIELD_SETUP_FUTURE_USAGE, this.mSetupFutureUsage != null ? this.mSetupFutureUsage.code : null);
        ((AbstractMap)map).put(FIELD_SOURCE, this.mSource);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentIntent && this.typedEquals((PaymentIntent)obj);
    }

    private boolean typedEquals(@NonNull PaymentIntent paymentIntent) {
        return ObjectUtils.equals(this.mId, paymentIntent.mId) && ObjectUtils.equals(this.mObjectType, paymentIntent.mObjectType) && ObjectUtils.equals(this.mAmount, paymentIntent.mAmount) && ObjectUtils.equals(this.mCanceledAt, paymentIntent.mCanceledAt) && ObjectUtils.equals(this.mCaptureMethod, paymentIntent.mCaptureMethod) && ObjectUtils.equals(this.mClientSecret, paymentIntent.mClientSecret) && ObjectUtils.equals(this.mConfirmationMethod, paymentIntent.mConfirmationMethod) && ObjectUtils.equals(this.mCreated, paymentIntent.mCreated) && ObjectUtils.equals(this.mCurrency, paymentIntent.mCurrency) && ObjectUtils.equals(this.mDescription, paymentIntent.mDescription) && ObjectUtils.equals(this.mLiveMode, paymentIntent.mLiveMode) && ObjectUtils.equals(this.mReceiptEmail, paymentIntent.mReceiptEmail) && ObjectUtils.equals(this.mSource, paymentIntent.mSource) && ObjectUtils.equals((Object)this.mStatus, (Object)paymentIntent.mStatus) && ObjectUtils.equals((Object)this.mSetupFutureUsage, (Object)paymentIntent.mSetupFutureUsage) && ObjectUtils.equals(this.mPaymentMethodTypes, paymentIntent.mPaymentMethodTypes) && ObjectUtils.equals(this.mNextAction, paymentIntent.mNextAction) && ObjectUtils.equals((Object)this.mNextActionType, (Object)paymentIntent.mNextActionType);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mId, this.mObjectType, this.mAmount, this.mCanceledAt, this.mCaptureMethod, this.mClientSecret, this.mConfirmationMethod, this.mCreated, this.mCurrency, this.mDescription, this.mLiveMode, this.mReceiptEmail, this.mSource, this.mStatus, this.mPaymentMethodTypes, this.mNextAction, this.mNextActionType, this.mSetupFutureUsage});
    }
}

